/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time;

import java.util.Formatter;
import java.util.Locale;
import org.jquantlib.QL;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.TimeUnit;

public class Period
implements Cloneable {
    private static final String UNKNOWN_FREQUENCY = "unknown frequency";
    private static final String UNKNOWN_TIME_UNIT = "unknown time unit";
    private static final String INCOMPATIBLE_TIME_UNIT = "incompatible time unit";
    private static final String UNDECIDABLE_COMPARISON = "undecidable comparison";
    private static final String DIVISION_BY_ZERO_ERROR = "cannot be divided by zero";
    public static final Period ONE_YEAR_FORWARD = new Period(1, TimeUnit.Years);
    public static final Period ONE_YEAR_BACKWARD = new Period(-1, TimeUnit.Years);
    public static final Period ONE_MONTH_FORWARD = new Period(1, TimeUnit.Months);
    public static final Period ONE_MONTH_BACKWARD = new Period(-1, TimeUnit.Months);
    public static final Period ONE_DAY_FORWARD = new Period(1, TimeUnit.Days);
    public static final Period ONE_DAY_BACKWARD = new Period(-1, TimeUnit.Days);
    private int length;
    private TimeUnit units;

    public Period() {
        this.length = 0;
        this.units = TimeUnit.Days;
    }

    public Period(int length, TimeUnit units) {
        this.length = length;
        this.units = units;
    }

    public Period(Frequency f) {
        switch (f) {
            case Once: 
            case NoFrequency: {
                this.units = TimeUnit.Days;
                this.length = 0;
                break;
            }
            case Annual: {
                this.units = TimeUnit.Years;
                this.length = 1;
                break;
            }
            case Semiannual: 
            case EveryFourthMonth: 
            case Quarterly: 
            case Bimonthly: 
            case Monthly: {
                this.units = TimeUnit.Months;
                this.length = 12 / f.toInteger();
                break;
            }
            case EveryFourthWeek: 
            case Biweekly: 
            case Weekly: {
                this.units = TimeUnit.Weeks;
                this.length = 52 / f.toInteger();
                break;
            }
            case Daily: {
                this.units = TimeUnit.Days;
                this.length = 1;
                break;
            }
            default: {
                throw new LibraryException(UNKNOWN_FREQUENCY);
            }
        }
    }

    protected Period clone() {
        return new Period(this.length, this.units);
    }

    public Period negative() {
        return new Period(-this.length(), this.units());
    }

    public Period addAssign(Period another) {
        if (this.length() == 0) {
            this.length = another.length();
            this.units = another.units();
        } else if (this.units == another.units()) {
            this.length += another.length();
        } else {
            block0 : switch (this.units) {
                case Years: {
                    switch (another.units()) {
                        case Months: {
                            this.units = another.units();
                            this.length = this.length * 12 + another.length();
                            break block0;
                        }
                        case Weeks: 
                        case Days: {
                            throw new IllegalArgumentException(INCOMPATIBLE_TIME_UNIT);
                        }
                    }
                    throw new LibraryException(UNKNOWN_TIME_UNIT);
                }
                case Months: {
                    switch (another.units()) {
                        case Years: {
                            this.length += another.length() * 12;
                            break block0;
                        }
                        case Weeks: 
                        case Days: {
                            throw new IllegalArgumentException(INCOMPATIBLE_TIME_UNIT);
                        }
                    }
                    throw new LibraryException(UNKNOWN_TIME_UNIT);
                }
                case Weeks: {
                    switch (another.units()) {
                        case Days: {
                            this.units = another.units();
                            this.length = this.length * 7 + another.length();
                            break block0;
                        }
                        case Months: 
                        case Years: {
                            throw new IllegalArgumentException(INCOMPATIBLE_TIME_UNIT);
                        }
                    }
                    throw new LibraryException(UNKNOWN_TIME_UNIT);
                }
                case Days: {
                    switch (another.units()) {
                        case Weeks: {
                            this.length += another.length() * 7;
                            break block0;
                        }
                        case Months: 
                        case Years: {
                            throw new IllegalArgumentException(INCOMPATIBLE_TIME_UNIT);
                        }
                    }
                    throw new LibraryException(UNKNOWN_TIME_UNIT);
                }
                default: {
                    throw new LibraryException(UNKNOWN_TIME_UNIT);
                }
            }
        }
        return this;
    }

    public Period subAssign(Period another) {
        return this.addAssign(another.clone().negative());
    }

    public Period divAssign(int scalar) {
        if (scalar == 0) {
            throw new ArithmeticException(DIVISION_BY_ZERO_ERROR);
        }
        if (this.length % scalar == 0) {
            this.length /= scalar;
        } else {
            switch (this.units) {
                case Years: {
                    this.units = TimeUnit.Months;
                    this.length *= 12;
                    break;
                }
                case Weeks: {
                    this.units = TimeUnit.Days;
                    this.length *= 7;
                }
            }
        }
        if (this.length % scalar == 0) {
            this.length /= scalar;
        } else {
            throw new LibraryException("cannot be divided by " + scalar);
        }
        return this;
    }

    public Period mul(int scalar) {
        return new Period(scalar * this.length, this.units);
    }

    public Period add(Period another) {
        return this.clone().addAssign(another);
    }

    public Period sub(Period another) {
        return this.clone().subAssign(another);
    }

    public Period div(int scalar) {
        return this.clone().divAssign(scalar);
    }

    public boolean eq(Period another) {
        return this.equals(another);
    }

    public boolean neq(Period another) {
        return !this.equals(another);
    }

    public boolean gt(Period another) {
        return another.lt(this);
    }

    public boolean le(Period another) {
        return this.lt(another) || this.eq(another);
    }

    public boolean ge(Period another) {
        return another.le(this);
    }

    public boolean lt(Period another) {
        if (this.length == 0) {
            return another.length > 0;
        }
        if (another.length == 0) {
            return this.length < 0;
        }
        if (this.units() == another.units()) {
            return this.length() < another.length();
        }
        if (this.units() == TimeUnit.Months && another.units() == TimeUnit.Years) {
            return this.length() < 12 * another.length();
        }
        if (this.units() == TimeUnit.Years && another.units() == TimeUnit.Months) {
            return 12 * this.length() < another.length();
        }
        if (this.units() == TimeUnit.Days && another.units() == TimeUnit.Weeks) {
            return this.length() < 7 * another.length();
        }
        if (this.units() == TimeUnit.Weeks && another.units() == TimeUnit.Days) {
            return 7 * this.length() < another.length();
        }
        int period1MinDays = this.getMinDays();
        int period1MaxDays = this.getMaxDays();
        int period2MinDays = another.getMinDays();
        int period2MaxDays = another.getMaxDays();
        if (period1MaxDays < period2MinDays) {
            return true;
        }
        if (period1MinDays > period2MaxDays) {
            return false;
        }
        throw new LibraryException(UNDECIDABLE_COMPARISON);
    }

    public final int length() {
        return this.length;
    }

    public final TimeUnit units() {
        return this.units;
    }

    public final Frequency frequency() {
        int length = Math.abs(this.length);
        if (length == 0) {
            return Frequency.NoFrequency;
        }
        switch (this.units) {
            case Years: {
                if (length == 1) {
                    return Frequency.Annual;
                }
                return Frequency.OtherFrequency;
            }
            case Months: {
                if (12 % length == 0 && length <= 12) {
                    return Frequency.valueOf(12 / length);
                }
                return Frequency.OtherFrequency;
            }
            case Weeks: {
                if (length == 1) {
                    return Frequency.Weekly;
                }
                if (length == 2) {
                    return Frequency.Biweekly;
                }
                if (length == 4) {
                    return Frequency.EveryFourthWeek;
                }
                return Frequency.OtherFrequency;
            }
            case Days: {
                if (length == 1) {
                    return Frequency.Daily;
                }
                return Frequency.OtherFrequency;
            }
        }
        throw new LibraryException(UNKNOWN_TIME_UNIT);
    }

    public double years(Period p) {
        if (p.length() == 0) {
            return 0.0;
        }
        switch (p.units()) {
            case Weeks: 
            case Days: {
                throw new IllegalArgumentException(UNDECIDABLE_COMPARISON);
            }
            case Months: {
                return (double)p.length() / 12.0;
            }
            case Years: {
                return p.length();
            }
        }
        throw new LibraryException(UNKNOWN_TIME_UNIT);
    }

    public double months(Period p) {
        if (p.length() == 0) {
            return 0.0;
        }
        switch (p.units()) {
            case Weeks: 
            case Days: {
                throw new IllegalArgumentException(UNDECIDABLE_COMPARISON);
            }
            case Months: {
                return p.length();
            }
            case Years: {
                return (double)p.length() * 12.0;
            }
        }
        throw new LibraryException(UNKNOWN_TIME_UNIT);
    }

    public double weeks(Period p) {
        if (p.length() == 0) {
            return 0.0;
        }
        switch (p.units()) {
            case Days: {
                return (double)p.length() / 7.0;
            }
            case Weeks: {
                return p.length();
            }
            case Months: 
            case Years: {
                throw new IllegalArgumentException(UNDECIDABLE_COMPARISON);
            }
        }
        throw new LibraryException(UNKNOWN_TIME_UNIT);
    }

    public double days(Period p) {
        if (p.length() == 0) {
            return 0.0;
        }
        switch (p.units()) {
            case Days: {
                return p.length();
            }
            case Weeks: {
                return (double)p.length() * 7.0;
            }
            case Months: 
            case Years: {
                throw new IllegalArgumentException(UNDECIDABLE_COMPARISON);
            }
        }
        throw new LibraryException(UNKNOWN_TIME_UNIT);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.length;
        result = 31 * result + (this.units == null ? 0 : this.units.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj instanceof Period && ((Period)obj).fEquals(this);
    }

    protected boolean fEquals(Period other) {
        if (this.length != other.length) {
            return false;
        }
        return !(this.units == null ? other.units != null : !this.units.equals((Object)other.units));
    }

    private int getMinDays() {
        switch (this.units()) {
            case Years: {
                return this.length() * 365;
            }
            case Months: {
                return this.length() * 28;
            }
            case Weeks: {
                return this.length() * 7;
            }
            case Days: {
                return this.length();
            }
        }
        throw new LibraryException(UNKNOWN_TIME_UNIT);
    }

    private int getMaxDays() {
        switch (this.units()) {
            case Years: {
                return this.length() * 366;
            }
            case Months: {
                return this.length() * 31;
            }
            case Weeks: {
                return this.length() * 7;
            }
            case Days: {
                return this.length();
            }
        }
        throw new LibraryException(UNKNOWN_TIME_UNIT);
    }

    public String toString() {
        return this.getLongFormat();
    }

    public String getLongFormat() {
        return this.getInternalLongFormat();
    }

    public String getShortFormat() {
        return this.getInternalShortFormat();
    }

    private String getInternalLongFormat() {
        String suffix = this.length == 1 ? "" : "s";
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        formatter.format("%d %s%s", this.length, this.units.getLongFormat(), suffix);
        return sb.toString();
    }

    private String getInternalShortFormat() {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        formatter.format("%d%s", this.length, this.units.getShortFormat());
        return sb.toString();
    }

    public void normalize() {
        if (this.length != 0) {
            switch (this.units) {
                case Days: {
                    if (this.length % 7 != 0) break;
                    this.length /= 7;
                    this.units = TimeUnit.Weeks;
                    break;
                }
                case Months: {
                    if (this.length % 12 != 0) break;
                    this.length /= 12;
                    this.units = TimeUnit.Years;
                    break;
                }
                case Weeks: 
                case Years: {
                    break;
                }
                default: {
                    QL.require(false, UNKNOWN_TIME_UNIT);
                }
            }
        }
    }
}

