/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jquantlib.QL;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Date;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Zahid Hussain", "Richard Gomes"})
public class Calendar {
    public static final String UNKNOWN_MARKET = "Unknown market";
    public static final String UKNOWN_BUSINESS_DAY_CONVENTION = "Unknown business day convention";
    protected Impl impl;

    public boolean empty() {
        return this.impl == null;
    }

    public String name() {
        return this.impl.name();
    }

    public boolean isBusinessDay(Date d) {
        if (this.impl.addedHolidays.contains(d)) {
            return false;
        }
        if (this.impl.removedHolidays.contains(d)) {
            return true;
        }
        return this.impl.isBusinessDay(d);
    }

    public boolean isHoliday(Date d) {
        return !this.isBusinessDay(d);
    }

    public boolean isWeekend(Weekday w) {
        return this.impl.isWeekend(w);
    }

    public boolean isEndOfMonth(Date d) {
        return d.month() != this.adjust(d.add(1)).month();
    }

    public Date endOfMonth(Date d) {
        return this.adjust(Date.endOfMonth(d), BusinessDayConvention.Preceding);
    }

    public void addHoliday(Date d) {
        this.impl.removedHolidays.remove(d);
        if (this.impl.isBusinessDay(d)) {
            this.impl.addedHolidays.add(d);
        }
    }

    public void removeHoliday(Date d) {
        this.impl.addedHolidays.remove(d);
        if (!this.impl.isBusinessDay(d)) {
            this.impl.removedHolidays.add(d);
        }
    }

    public static List<Date> holidayList(Calendar c, Date from, Date to, boolean includeWeekEnds) {
        QL.require(to.gt(from), "'from' date (" + from.toString() + ") must be earlier than 'to' date (" + to.toString() + ")");
        ArrayList<Date> result = new ArrayList<Date>();
        Date d = from.clone();
        while (d.le(to)) {
            if (c.isHoliday(d) && (includeWeekEnds || !c.isWeekend(d.weekday()))) {
                result.add(d);
            }
            d = d.add(1);
        }
        return result;
    }

    public Date adjust(Date date) {
        return this.adjust(date, BusinessDayConvention.Following);
    }

    public Date adjust(Date d, BusinessDayConvention c) {
        if (c == BusinessDayConvention.Unadjusted) {
            return d.clone();
        }
        Date d1 = d.clone();
        if (c == BusinessDayConvention.Following || c == BusinessDayConvention.ModifiedFollowing) {
            while (this.isHoliday(d1)) {
                d1.inc();
            }
            if (c == BusinessDayConvention.ModifiedFollowing && d1.month() != d.month()) {
                return this.adjust(d, BusinessDayConvention.Preceding);
            }
        } else if (c == BusinessDayConvention.Preceding || c == BusinessDayConvention.ModifiedPreceding) {
            while (this.isHoliday(d1)) {
                d1.dec();
            }
            if (c == BusinessDayConvention.ModifiedPreceding && d1.month() != d.month()) {
                return this.adjust(d, BusinessDayConvention.Following);
            }
        } else {
            throw new LibraryException(UKNOWN_BUSINESS_DAY_CONVENTION);
        }
        return d1;
    }

    public Date advance(Date date, Period period, BusinessDayConvention convention) {
        return this.advance(date, period, convention, false);
    }

    public Date advance(Date date, Period period, BusinessDayConvention convention, boolean endOfMonth) {
        return this.advance(date, period.length(), period.units(), convention, endOfMonth);
    }

    public Date advance(Date date, int n, TimeUnit unit) {
        return this.advance(date, n, unit, BusinessDayConvention.Following, false);
    }

    public Date advance(Date date, Period period) {
        return this.advance(date, period, BusinessDayConvention.Following, false);
    }

    public Date advance(Date d, int n, TimeUnit unit, BusinessDayConvention c, boolean endOfMonth) {
        QL.require(d != null && !d.isNull(), "null date");
        if (n == 0) {
            return this.adjust(d, c);
        }
        if (unit == TimeUnit.Days) {
            Date d1 = d.clone();
            if (n > 0) {
                while (n > 0) {
                    d1.inc();
                    while (this.isHoliday(d1)) {
                        d1.inc();
                    }
                    --n;
                }
            } else {
                while (n < 0) {
                    d1.dec();
                    while (this.isHoliday(d1)) {
                        d1.dec();
                    }
                    ++n;
                }
            }
            return d1;
        }
        if (unit == TimeUnit.Weeks) {
            Date d1 = d.add(new Period(n, unit));
            return this.adjust(d1, c);
        }
        Date d1 = d.add(new Period(n, unit));
        if (endOfMonth && this.isEndOfMonth(d)) {
            return this.endOfMonth(d1);
        }
        return this.adjust(d1, c);
    }

    public int businessDaysBetween(Date from, Date to) {
        return this.businessDaysBetween(from, to, true, false);
    }

    public int businessDaysBetween(Date from, Date to, boolean includeFirst, boolean includeLast) {
        int wd = 0;
        if (from.ne(to)) {
            if (from.lt(to)) {
                Date d = from.clone();
                while (d.lt(to)) {
                    if (this.isBusinessDay(d)) {
                        ++wd;
                    }
                    d = d.add(1);
                }
                if (this.isBusinessDay(to)) {
                    ++wd;
                }
            } else if (from.gt(to)) {
                Date d = to.clone();
                while (d.lt(from)) {
                    if (this.isBusinessDay(d)) {
                        ++wd;
                    }
                    d = d.add(1);
                }
                if (this.isBusinessDay(from)) {
                    ++wd;
                }
            }
            if (this.isBusinessDay(from) && !includeFirst) {
                --wd;
            }
            if (this.isBusinessDay(to) && !includeLast) {
                --wd;
            }
            if (from.gt(to)) {
                wd = -wd;
            }
        }
        return wd;
    }

    public static boolean eq(Calendar c1, Calendar c2) {
        return c1.empty() && c2.empty() || !c1.empty() && !c2.empty() && c1.name().equals(c2.name());
    }

    public static boolean ne(Calendar c1, Calendar c2) {
        return !Calendar.eq(c1, c2);
    }

    protected abstract class OrthodoxImpl
    extends Impl {
        private final short[] easterMonday;

        protected OrthodoxImpl() {
            this.easterMonday = new short[]{105, 118, 110, 102, 121, 106, 126, 118, 102, 122, 114, 99, 118, 110, 95, 115, 106, 126, 111, 103, 122, 107, 99, 119, 110, 123, 115, 107, 126, 111, 103, 123, 107, 99, 119, 104, 123, 115, 100, 120, 111, 96, 116, 108, 127, 112, 104, 124, 115, 100, 120, 112, 96, 116, 108, 128, 112, 104, 124, 109, 100, 120, 105, 125, 116, 101, 121, 113, 104, 117, 109, 101, 120, 105, 125, 117, 101, 121, 113, 98, 117, 109, 129, 114, 105, 125, 110, 102, 121, 106, 98, 118, 109, 122, 114, 106, 118, 110, 102, 122, 106, 126, 118, 103, 122, 114, 99, 119, 110, 95, 115, 107, 126, 111, 103, 123, 107, 99, 119, 111, 123, 115, 107, 127, 111, 103, 123, 108, 99, 119, 104, 124, 115, 100, 120, 112, 96, 116, 108, 128, 112, 104, 124, 116, 100, 120, 112, 97, 116, 108, 128, 113, 104, 124, 109, 101, 120, 105, 125, 117, 101, 121, 113, 105, 117, 109, 101, 121, 105, 125, 110, 102, 121, 113, 98, 118, 109, 129, 114, 106, 125, 110, 102, 122, 106, 98, 118, 110, 122, 114, 99, 119, 110, 102, 115, 107, 126, 118, 103, 123, 115, 100, 120, 112, 96, 116, 108, 128, 112, 104, 124, 109, 100, 120, 105, 125, 116, 108, 121, 113, 104, 124, 109, 101, 120, 105, 125, 117, 101, 121, 113, 98, 117, 109, 129, 114, 105, 125, 110, 102, 121, 113, 98, 118, 109, 129, 114, 106, 125, 110, 102, 122, 106, 126, 118, 103, 122, 114, 99, 119, 110, 102, 115, 107, 126, 111, 103, 123, 114, 99, 119, 111, 130, 115, 107, 127, 111, 103, 123, 108, 99, 119, 104, 124, 115, 100, 120, 112, 103, 116, 108, 128, 119, 104, 124, 116, 100, 120, 112};
        }

        @Override
        public boolean isWeekend(Weekday w) {
            return w == Weekday.Saturday || w == Weekday.Sunday;
        }

        protected final int easterMonday(int year) {
            return this.easterMonday[year - 1901];
        }
    }

    protected abstract class WesternImpl
    extends Impl {
        private final short[] easterMonday;

        protected WesternImpl() {
            this.easterMonday = new short[]{98, 90, 103, 95, 114, 106, 91, 111, 102, 87, 107, 99, 83, 103, 95, 115, 99, 91, 111, 96, 87, 107, 92, 112, 103, 95, 108, 100, 91, 111, 96, 88, 107, 92, 112, 104, 88, 108, 100, 85, 104, 96, 116, 101, 92, 112, 97, 89, 108, 100, 85, 105, 96, 109, 101, 93, 112, 97, 89, 109, 93, 113, 105, 90, 109, 101, 86, 106, 97, 89, 102, 94, 113, 105, 90, 110, 101, 86, 106, 98, 110, 102, 94, 114, 98, 90, 110, 95, 86, 106, 91, 111, 102, 94, 107, 99, 90, 103, 95, 115, 106, 91, 111, 103, 87, 107, 99, 84, 103, 95, 115, 100, 91, 111, 96, 88, 107, 92, 112, 104, 95, 108, 100, 92, 111, 96, 88, 108, 92, 112, 104, 89, 108, 100, 85, 105, 96, 116, 101, 93, 112, 97, 89, 109, 100, 85, 105, 97, 109, 101, 93, 113, 97, 89, 109, 94, 113, 105, 90, 110, 101, 86, 106, 98, 89, 102, 94, 114, 105, 90, 110, 102, 86, 106, 98, 111, 102, 94, 114, 99, 90, 110, 95, 87, 106, 91, 111, 103, 94, 107, 99, 91, 103, 95, 115, 107, 91, 111, 103, 88, 108, 100, 85, 105, 96, 109, 101, 93, 112, 97, 89, 109, 93, 113, 105, 90, 109, 101, 86, 106, 97, 89, 102, 94, 113, 105, 90, 110, 101, 86, 106, 98, 110, 102, 94, 114, 98, 90, 110, 95, 86, 106, 91, 111, 102, 94, 107, 99, 90, 103, 95, 115, 106, 91, 111, 103, 87, 107, 99, 84, 103, 95, 115, 100, 91, 111, 96, 88, 107, 92, 112, 104, 95, 108, 100, 92, 111, 96, 88, 108, 92, 112, 104, 89, 108, 100, 85, 105, 96, 116, 101, 93, 112, 97, 89, 109, 100, 85, 105};
        }

        @Override
        public boolean isWeekend(Weekday w) {
            return w == Weekday.Saturday || w == Weekday.Sunday;
        }

        protected int easterMonday(int y) {
            return this.easterMonday[y - 1901];
        }
    }

    protected abstract class Impl {
        private final Set<Date> addedHolidays = new HashSet<Date>();
        private final Set<Date> removedHolidays = new HashSet<Date>();

        protected Impl() {
        }

        public abstract String name();

        public abstract boolean isBusinessDay(Date var1);

        public abstract boolean isWeekend(Weekday var1);
    }
}

