/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.math.solvers1D;

import org.jquantlib.QL;
import org.jquantlib.math.Ops;
import org.jquantlib.math.solvers1D.Brent;
import org.junit.Assert;
import org.junit.Test;

public class BrentTest {
    public BrentTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testInvertSquare() {
        Ops.DoubleOp square = new Ops.DoubleOp(){

            @Override
            public double op(double x) {
                return x * x - 1.0;
            }
        };
        double accuracy = 1.0E-15;
        Brent brent = new Brent();
        double soln = brent.solve(square, 1.0E-15, 0.01, 0.0, 2.0);
        if (Math.abs(1.0 - soln) > 1.0E-15) {
            Assert.fail((String)("expected: 1.0 but was: " + (soln - 1.0E-15)));
        }
        if (brent.getNumEvaluations() != 10) {
            Assert.fail((String)("expected: 10 but was: " + brent.getNumEvaluations()));
        }
        if (Math.abs(1.0 - (soln = brent.solve(square, 1.0E-15, 0.01, 0.1))) > 1.0E-15) {
            Assert.fail((String)("expected: 1.0 but was: " + (soln - 1.0E-15)));
        }
        if (brent.getNumEvaluations() != 13) {
            Assert.fail((String)("expected: 13 but was: " + brent.getNumEvaluations()));
        }
    }
}

