/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.math.optimization;

import java.util.ArrayList;
import java.util.List;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.optimization.Constraint;
import org.jquantlib.math.optimization.CostFunction;
import org.jquantlib.math.optimization.EndCriteria;
import org.jquantlib.math.optimization.LevenbergMarquardt;
import org.jquantlib.math.optimization.NoConstraint;
import org.jquantlib.math.optimization.OptimizationMethod;
import org.jquantlib.math.optimization.Problem;
import org.jquantlib.math.optimization.Simplex;
import org.junit.Ignore;
import org.junit.Test;

public class OptimizerTest {
    @Ignore
    @Test
    public void testOptimizers() {
        System.out.println("::::: " + this.getClass().getSimpleName() + " :::::");
        System.out.println("Testing optimizers... ");
        ArrayList<OneDimensionalPolynomDegreeN> costFunctions_ = new ArrayList<OneDimensionalPolynomDegreeN>();
        ArrayList<NoConstraint> constraints_ = new ArrayList<NoConstraint>();
        ArrayList<Array> initialValues_ = new ArrayList<Array>();
        ArrayList<Integer> maxIterations_ = new ArrayList<Integer>();
        ArrayList<Integer> maxStationaryStateIterations_ = new ArrayList<Integer>();
        ArrayList<Double> rootEpsilons_ = new ArrayList<Double>();
        ArrayList<Double> functionEpsilons_ = new ArrayList<Double>();
        ArrayList<Double> gradientNormEpsilons_ = new ArrayList<Double>();
        ArrayList<EndCriteria> endCriterias_ = new ArrayList<EndCriteria>();
        ArrayList<List<OptimizationMethod>> optimizationMethods_ = new ArrayList<List<OptimizationMethod>>();
        double[] xMinExpected = new double[1];
        double[] yMinExpected = new double[1];
        double a = 1.0;
        double b = 1.0;
        double c = 1.0;
        ArrayList<Double> coefficients = new ArrayList<Double>();
        coefficients.add(1.0);
        coefficients.add(1.0);
        coefficients.add(1.0);
        xMinExpected[0] = -0.5;
        yMinExpected[0] = 0.75;
        ArrayList<Double> xMinExpected_ = new ArrayList<Double>();
        ArrayList<Double> yMinExpected_ = new ArrayList<Double>();
        xMinExpected_.add(xMinExpected[xMinExpected.length - 1]);
        yMinExpected_.add(xMinExpected[yMinExpected.length - 1]);
        costFunctions_.add(new OneDimensionalPolynomDegreeN(coefficients));
        constraints_.add(new NoConstraint());
        Array initialValue = new Array(0);
        initialValue.add(-100.0);
        initialValues_.add(initialValue);
        maxIterations_.add(1000);
        maxStationaryStateIterations_.add(100);
        rootEpsilons_.add(1.0E-8);
        functionEpsilons_.add(1.0E-16);
        gradientNormEpsilons_.add(1.0E-8);
        endCriterias_.add(new EndCriteria((Integer)maxIterations_.get(maxIterations_.size() - 1), (Integer)maxStationaryStateIterations_.get(maxStationaryStateIterations_.size() - 1), (Double)rootEpsilons_.get(rootEpsilons_.size() - 1), (Double)functionEpsilons_.get(functionEpsilons_.size() - 1), (Double)gradientNormEpsilons_.get(gradientNormEpsilons_.size() - 1)));
        OptimizationMethodType[] optimizationMethodTypes = new OptimizationMethodType[]{OptimizationMethodType.simplex};
        double simplexLambda = 0.1;
        double levenbergMarquardtEpsfcn = Math.pow(10.0, -0.8);
        double levenbergMarquardtXtol = Math.pow(10.0, -0.8);
        double levenbergMarquardtGtol = Math.pow(10.0, -0.8);
        optimizationMethods_.add(this.makeOptimizationMethods(optimizationMethodTypes, 0.1, levenbergMarquardtEpsfcn, levenbergMarquardtXtol, levenbergMarquardtGtol));
        for (int i = 0; i < costFunctions_.size(); ++i) {
            Problem problem = new Problem((CostFunction)costFunctions_.get(i), (Constraint)constraints_.get(i), (Array)initialValues_.get(i));
            for (int j = 0; j < ((List)optimizationMethods_.get(i)).size(); ++j) {
                EndCriteria.Type endCriteriaResult = ((OptimizationMethod)((List)optimizationMethods_.get(i)).get(j)).minimize(problem, (EndCriteria)endCriterias_.get(i));
                Array xMinCalculated = problem.currentValue();
                Array yMinCalculated = problem.values(xMinCalculated);
                for (int k = 0; k < xMinCalculated.size(); ++k) {
                    System.out.println("costFunction = " + String.valueOf(i) + "\n" + "optimizer =  " + j + "\n" + "    x expected:    " + xMinExpected_.get(k) + "\n" + "    x calculated:  " + xMinCalculated.get(k) + "\n" + "    x difference:  " + ((Double)xMinExpected_.get(k) - xMinCalculated.get(k)) + "\n" + "    rootEpsilon:   " + rootEpsilons_.get(i) + "\n" + "    y expected:    " + yMinExpected_.get(k) + "\n" + "    y calculated:  " + yMinCalculated.get(k) + "\n" + "    y difference:  " + ((Double)yMinExpected_.get(k) - yMinCalculated.get(k)) + "\n" + "    functionEpsilon:   " + functionEpsilons_.get(i) + "\n" + "    endCriteriaResult:  " + (Object)((Object)endCriteriaResult));
                }
            }
        }
    }

    private List<OptimizationMethod> makeOptimizationMethods(OptimizationMethodType[] optimizationMethodTypes, double simplexLambda, double levenbergMarquardtEpsfcn, double levenbergMarquardtXtol, double levenbergMarquardtGtol) {
        ArrayList<OptimizationMethod> results = new ArrayList<OptimizationMethod>();
        for (int i = 0; i < optimizationMethodTypes.length; ++i) {
            results.add(this.makeOptimizationMethod(optimizationMethodTypes[i], simplexLambda, levenbergMarquardtEpsfcn, levenbergMarquardtXtol, levenbergMarquardtGtol));
        }
        return results;
    }

    private OptimizationMethod makeOptimizationMethod(OptimizationMethodType optimizationMethodType, double simplexLambda, double levenbergMarquardtEpsfcn, double levenbergMarquardtXtol, double levenbergMarquardtGtol) {
        switch (optimizationMethodType) {
            case simplex: {
                return new Simplex(simplexLambda);
            }
            case levenbergMarquardt: {
                return new LevenbergMarquardt(levenbergMarquardtEpsfcn, levenbergMarquardtXtol, levenbergMarquardtXtol);
            }
        }
        throw new IllegalArgumentException("unknown Optimization Method type");
    }

    private class OneDimensionalPolynomDegreeN
    extends CostFunction {
        private final List<Double> coefficients_;
        private final int polynominalDegree_;

        public OneDimensionalPolynomDegreeN(List<Double> coefficients) {
            this.coefficients_ = coefficients;
            this.polynominalDegree_ = coefficients.size() - 1;
        }

        @Override
        public double value(Array x) {
            if (x.size() != 1) {
                throw new IllegalArgumentException("Independent variable must be 1 dimensional");
            }
            double y = 0.0;
            for (int i = 0; i <= this.polynominalDegree_; ++i) {
                y += this.coefficients_.get(i) * Math.pow(x.first(), i);
            }
            return y;
        }

        @Override
        public Array values(Array x) {
            if (x.size() != 1) {
                throw new IllegalArgumentException("Independent variable must be 1 dimensional");
            }
            Array y = new Array(1);
            y.set(0, this.value(x));
            return y;
        }
    }

    private static enum OptimizationMethodType {
        simplex,
        levenbergMarquardt,
        conjugateGradient,
        steepestDescent;

    }
}

