/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.math.interpolations;

import java.util.ArrayList;
import org.jquantlib.QL;
import org.jquantlib.math.interpolations.SABRInterpolation;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.optimization.EndCriteria;
import org.jquantlib.math.optimization.LevenbergMarquardt;
import org.jquantlib.math.optimization.OptimizationMethod;
import org.jquantlib.math.optimization.Simplex;
import org.jquantlib.termstructures.volatilities.Sabr;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class SABRInterpolationTest {
    @Ignore
    @Test
    public void testSABRInterpolationTest() {
        int i;
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
        QL.info("Testing SABR interpolation...");
        double tolerance = 2.0E-13;
        double[] strikes = new double[31];
        double[] volatilities = new double[31];
        strikes[0] = 0.03;
        strikes[1] = 0.032;
        strikes[2] = 0.034;
        strikes[3] = 0.036;
        strikes[4] = 0.038;
        strikes[5] = 0.04;
        strikes[6] = 0.042;
        strikes[7] = 0.044;
        strikes[8] = 0.046;
        strikes[9] = 0.048;
        strikes[10] = 0.05;
        strikes[11] = 0.052;
        strikes[12] = 0.054;
        strikes[13] = 0.056;
        strikes[14] = 0.058;
        strikes[15] = 0.06;
        strikes[16] = 0.062;
        strikes[17] = 0.064;
        strikes[18] = 0.066;
        strikes[19] = 0.068;
        strikes[20] = 0.07;
        strikes[21] = 0.072;
        strikes[22] = 0.074;
        strikes[23] = 0.076;
        strikes[24] = 0.078;
        strikes[25] = 0.08;
        strikes[26] = 0.082;
        strikes[27] = 0.084;
        strikes[28] = 0.086;
        strikes[29] = 0.088;
        strikes[30] = 0.09;
        volatilities[0] = 1.16725837321531;
        volatilities[1] = 1.15226075991385;
        volatilities[2] = 1.13829711098834;
        volatilities[3] = 1.12524190877505;
        volatilities[4] = 1.11299079244474;
        volatilities[5] = 1.10145609357162;
        volatilities[6] = 1.09056348513411;
        volatilities[7] = 1.08024942745106;
        volatilities[8] = 1.07045919457758;
        volatilities[9] = 1.06114533019077;
        volatilities[10] = 1.05226642581503;
        volatilities[11] = 1.04378614411707;
        volatilities[12] = 1.03567243073732;
        volatilities[13] = 1.0278968727451;
        volatilities[14] = 1.02043417226345;
        volatilities[15] = 1.01326171139321;
        volatilities[16] = 1.00635919013311;
        volatilities[17] = 0.999708323124949;
        volatilities[18] = 0.993292584155381;
        volatilities[19] = 0.987096989695393;
        volatilities[20] = 0.98110791455717;
        volatilities[21] = 0.975312934134512;
        volatilities[22] = 0.969700688771689;
        volatilities[23] = 0.964260766651027;
        volatilities[24] = 0.958983602256592;
        volatilities[25] = 0.953860388001395;
        volatilities[26] = 0.948882997029509;
        volatilities[27] = 0.944043915545469;
        volatilities[28] = 0.939336183299237;
        volatilities[29] = 0.934753341079515;
        volatilities[30] = 0.930289384251337;
        Array strikeArray = new Array(strikes.length);
        Array volatilityArray = new Array(volatilities.length);
        for (i = 0; i < strikes.length; ++i) {
            strikeArray.set(i, strikes[i]);
        }
        for (i = 0; i < volatilities.length; ++i) {
            volatilityArray.set(i, volatilities[i]);
        }
        double expiry = 1.0;
        double forward = 0.039;
        double initialAlpha = 0.3;
        double initialBeta = 0.6;
        double initialNu = 0.02;
        double initialRho = 0.01;
        for (int i2 = 0; i2 < strikes.length; ++i2) {
            double calculatedVol = new Sabr().sabrVolatility(strikes[i2], 0.039, 1.0, 0.3, 0.6, 0.02, 0.01);
            Assert.assertFalse((String)("failed to calculate Sabr function at strike " + strikes[i2] + "\n    expected:   " + volatilities[i2] + "\n    calculated: " + calculatedVol + "\n    error:      " + Math.abs(calculatedVol - volatilities[i2])), (Math.abs(volatilities[i2] - calculatedVol) > 2.0E-13 ? 1 : 0) != 0);
        }
        double alphaGuess = Double.MAX_VALUE;
        double betaGuess = Double.MAX_VALUE;
        double nuGuess = Double.MAX_VALUE;
        double rhoGuess = Double.MAX_VALUE;
        boolean[] vegaWeighted = new boolean[]{true, false};
        boolean[] isAlphaFixed = new boolean[]{true, false};
        boolean[] isBetaFixed = new boolean[]{true, false};
        boolean[] isNuFixed = new boolean[]{true, false};
        boolean[] isRhoFixed = new boolean[]{true, false};
        double calibrationTolerance = 5.0E-8;
        ArrayList<OptimizationMethod> methods_ = new ArrayList<OptimizationMethod>();
        methods_.add(new Simplex(0.01));
        methods_.add(new LevenbergMarquardt(1.0E-8, 1.0E-8, 1.0E-8));
        EndCriteria endCriteria = new EndCriteria(100000, 100, 1.0E-8, 1.0E-8, 1.0E-8);
        for (int j = 0; j < methods_.size(); ++j) {
            for (int i3 = 0; i3 < vegaWeighted.length; ++i3) {
                for (int k_a = 0; k_a < isAlphaFixed.length; ++k_a) {
                    for (int k_b = 0; k_b < isBetaFixed.length; ++k_b) {
                        for (int k_n = 0; k_n < isNuFixed.length; ++k_n) {
                            for (int k_r = 0; k_r < isRhoFixed.length; ++k_r) {
                                SABRInterpolation sabrInterpolation = new SABRInterpolation(strikeArray, volatilityArray, 1.0, 0.039, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE, isAlphaFixed[k_a], isBetaFixed[k_b], isNuFixed[k_n], isRhoFixed[k_r], vegaWeighted[i3], endCriteria, (OptimizationMethod)methods_.get(j));
                                sabrInterpolation.update();
                                double calibratedAlpha = sabrInterpolation.alpha();
                                double calibratedBeta = sabrInterpolation.beta();
                                double calibratedNu = sabrInterpolation.nu();
                                double calibratedRho = sabrInterpolation.rho();
                                double error = Math.abs(0.3 - calibratedAlpha);
                                Assert.assertFalse((String)("\nfailed to calibrate alpha Sabr parameter:\n    expected:        0.3\n    calibrated:      " + calibratedAlpha + "\n    error:           " + error), (error > 5.0E-8 ? 1 : 0) != 0);
                                error = Math.abs(0.6 - calibratedBeta);
                                Assert.assertFalse((String)("\nfailed to calibrate beta Sabr parameter:\n    expected:        0.6\n    calibrated:      " + calibratedBeta + "\n    error:           " + error), (error > 5.0E-8 ? 1 : 0) != 0);
                                error = Math.abs(0.02 - calibratedNu);
                                Assert.assertFalse((String)("\nfailed to calibrate nu Sabr parameter:\n    expected:        0.02\n    calibrated:      " + calibratedNu + "\n    error:           " + error), (error > 5.0E-8 ? 1 : 0) != 0);
                                error = Math.abs(0.01 - calibratedRho);
                                Assert.assertFalse((String)("\nfailed to calibrate rho Sabr parameter:\n    expected:        0.01\n    calibrated:      " + calibratedRho + "\n    error:           " + error), (error > 5.0E-8 ? 1 : 0) != 0);
                            }
                        }
                    }
                }
            }
        }
    }
}

