/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.math.integrals;

import org.jquantlib.QL;
import org.jquantlib.math.Ops;
import org.jquantlib.math.distributions.NormalDistribution;
import org.jquantlib.math.functions.Constant;
import org.jquantlib.math.functions.Cos;
import org.jquantlib.math.functions.Identity;
import org.jquantlib.math.functions.Sin;
import org.jquantlib.math.functions.Square;
import org.jquantlib.math.integrals.GaussKronrodAdaptive;
import org.jquantlib.math.integrals.GaussKronrodNonAdaptive;
import org.jquantlib.math.integrals.Integrator;
import org.jquantlib.math.integrals.SegmentIntegral;
import org.jquantlib.math.integrals.SimpsonIntegral;
import org.jquantlib.math.integrals.TrapezoidIntegral;
import org.junit.Assert;
import org.junit.Test;

public class IntegralsTest {
    private static final double tolerance = 1.0E-6;

    private void testSingle(Integrator integrator, String tag, Ops.DoubleOp f, double xMin, double xMax, double expected) {
        double calculated = integrator.op(f, xMin, xMax);
        if (Math.abs(calculated - expected) > 1.0E-6) {
            StringBuilder sb = new StringBuilder();
            sb.append("integrating ").append(tag).append('\n');
            sb.append("    calculated: ").append(calculated).append('\n');
            sb.append("    expeceted:  ").append(expected);
            Assert.fail((String)sb.toString());
        }
    }

    private void testSeveral(Integrator I) {
        this.testSingle(I, "f(x) = 1", new Constant(1.0), 0.0, 1.0, 1.0);
        this.testSingle(I, "f(x) = x", new Identity(), 0.0, 1.0, 0.5);
        this.testSingle(I, "f(x) = x^2", new Square(), 0.0, 1.0, 0.3333333333333333);
        this.testSingle(I, "f(x) = sin(x)", new Sin(), 0.0, Math.PI, 2.0);
        this.testSingle(I, "f(x) = cos(x)", new Cos(), 0.0, Math.PI, 0.0);
        this.testSingle(I, "f(x) = Gaussian(x)", new NormalDistribution(), -10.0, 10.0, 1.0);
    }

    @Test
    public void testSegment() {
        QL.info("Testing segment integration...");
        this.testSeveral(new SegmentIntegral(10000));
    }

    @Test
    public void testTrapezoid() {
        QL.info("Testing trapezoid integration...");
        this.testSeveral(new TrapezoidIntegral(TrapezoidIntegral.Default.class, 1.0E-6, 10000));
    }

    @Test
    public void testMidPointTrapezoid() {
        QL.info("Testing mid-point trapezoid integration...");
        this.testSeveral(new TrapezoidIntegral(TrapezoidIntegral.MidPoint.class, 1.0E-6, 10000));
    }

    @Test
    public void testSimpson() {
        QL.info("Testing Simpson integration...");
        this.testSeveral(new SimpsonIntegral(1.0E-6, 10000));
    }

    @Test
    public void testGaussKronrodAdaptive() {
        QL.info("Testing adaptive Gauss-Kronrod integration...");
        int maxEvaluations = 1000;
        this.testSeveral(new GaussKronrodAdaptive(1.0E-6, 1000));
    }

    @Test
    public void testGaussKronrodNonAdaptive() {
        QL.info("Testing non-adaptive Gauss-Kronrod integration...");
        double precision = 1.0E-6;
        int maxEvaluations = 100;
        double relativeAccuracy = 1.0E-6;
        GaussKronrodNonAdaptive gaussKronrodNonAdaptive = new GaussKronrodNonAdaptive(1.0E-6, 100, 1.0E-6);
        this.testSeveral(gaussKronrodNonAdaptive);
    }
}

