/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.instruments;

import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.daycounters.Actual360;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.exercise.EuropeanExercise;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.BarrierOption;
import org.jquantlib.instruments.BarrierType;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.PlainVanillaPayoff;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.pricingengines.barrier.AnalyticBarrierEngine;
import org.jquantlib.processes.BlackScholesMertonProcess;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.BlackVolTermStructure;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.testsuite.util.Utilities;
import org.jquantlib.time.Date;
import org.junit.Assert;
import org.junit.Test;

public class BarrierOptionTest {
    public BarrierOptionTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testHaugValues() {
        QL.info("Testing barrier options against Haug's values...");
        NewBarrierOptionData[] values = new NewBarrierOptionData[]{new NewBarrierOptionData(BarrierType.DownOut, 95.0, 3.0, Option.Type.Call, 90.0, 100.0, 0.04, 0.08, 0.5, 0.25, 9.0246, 1.0E-4), new NewBarrierOptionData(BarrierType.DownOut, 95.0, 3.0, Option.Type.Call, 100.0, 100.0, 0.04, 0.08, 0.5, 0.25, 6.7924, 1.0E-4), new NewBarrierOptionData(BarrierType.DownOut, 95.0, 3.0, Option.Type.Call, 110.0, 100.0, 0.04, 0.08, 0.5, 0.25, 4.8759, 1.0E-4), new NewBarrierOptionData(BarrierType.DownOut, 100.0, 3.0, Option.Type.Call, 90.0, 100.0, 0.04, 0.08, 0.5, 0.25, 3.0, 1.0E-4), new NewBarrierOptionData(BarrierType.DownOut, 100.0, 3.0, Option.Type.Call, 100.0, 100.0, 0.04, 0.08, 0.5, 0.25, 3.0, 1.0E-4), new NewBarrierOptionData(BarrierType.DownOut, 100.0, 3.0, Option.Type.Call, 110.0, 100.0, 0.04, 0.08, 0.5, 0.25, 3.0, 1.0E-4), new NewBarrierOptionData(BarrierType.UpOut, 105.0, 3.0, Option.Type.Call, 90.0, 100.0, 0.04, 0.08, 0.5, 0.25, 2.6789, 1.0E-4), new NewBarrierOptionData(BarrierType.UpOut, 105.0, 3.0, Option.Type.Call, 100.0, 100.0, 0.04, 0.08, 0.5, 0.25, 2.358, 1.0E-4), new NewBarrierOptionData(BarrierType.UpOut, 105.0, 3.0, Option.Type.Call, 110.0, 100.0, 0.04, 0.08, 0.5, 0.25, 2.3453, 1.0E-4), new NewBarrierOptionData(BarrierType.DownIn, 95.0, 3.0, Option.Type.Call, 90.0, 100.0, 0.04, 0.08, 0.5, 0.25, 7.7627, 1.0E-4), new NewBarrierOptionData(BarrierType.DownIn, 95.0, 3.0, Option.Type.Call, 100.0, 100.0, 0.04, 0.08, 0.5, 0.25, 4.0109, 1.0E-4), new NewBarrierOptionData(BarrierType.DownIn, 95.0, 3.0, Option.Type.Call, 110.0, 100.0, 0.04, 0.08, 0.5, 0.25, 2.0576, 1.0E-4), new NewBarrierOptionData(BarrierType.DownIn, 100.0, 3.0, Option.Type.Call, 90.0, 100.0, 0.04, 0.08, 0.5, 0.25, 13.8333, 1.0E-4), new NewBarrierOptionData(BarrierType.DownIn, 100.0, 3.0, Option.Type.Call, 100.0, 100.0, 0.04, 0.08, 0.5, 0.25, 7.8494, 1.0E-4), new NewBarrierOptionData(BarrierType.DownIn, 100.0, 3.0, Option.Type.Call, 110.0, 100.0, 0.04, 0.08, 0.5, 0.25, 3.9795, 1.0E-4), new NewBarrierOptionData(BarrierType.UpIn, 105.0, 3.0, Option.Type.Call, 90.0, 100.0, 0.04, 0.08, 0.5, 0.25, 14.1112, 1.0E-4), new NewBarrierOptionData(BarrierType.UpIn, 105.0, 3.0, Option.Type.Call, 100.0, 100.0, 0.04, 0.08, 0.5, 0.25, 8.4482, 1.0E-4), new NewBarrierOptionData(BarrierType.UpIn, 105.0, 3.0, Option.Type.Call, 110.0, 100.0, 0.04, 0.08, 0.5, 0.25, 4.591, 1.0E-4), new NewBarrierOptionData(BarrierType.DownOut, 95.0, 3.0, Option.Type.Call, 90.0, 100.0, 0.04, 0.08, 0.5, 0.3, 8.8334, 1.0E-4), new NewBarrierOptionData(BarrierType.DownOut, 95.0, 3.0, Option.Type.Call, 100.0, 100.0, 0.04, 0.08, 0.5, 0.3, 7.0285, 1.0E-4), new NewBarrierOptionData(BarrierType.DownOut, 95.0, 3.0, Option.Type.Call, 110.0, 100.0, 0.04, 0.08, 0.5, 0.3, 5.4137, 1.0E-4), new NewBarrierOptionData(BarrierType.DownOut, 100.0, 3.0, Option.Type.Call, 90.0, 100.0, 0.04, 0.08, 0.5, 0.3, 3.0, 1.0E-4), new NewBarrierOptionData(BarrierType.DownOut, 100.0, 3.0, Option.Type.Call, 100.0, 100.0, 0.04, 0.08, 0.5, 0.3, 3.0, 1.0E-4), new NewBarrierOptionData(BarrierType.DownOut, 100.0, 3.0, Option.Type.Call, 110.0, 100.0, 0.04, 0.08, 0.5, 0.3, 3.0, 1.0E-4), new NewBarrierOptionData(BarrierType.UpOut, 105.0, 3.0, Option.Type.Call, 90.0, 100.0, 0.04, 0.08, 0.5, 0.3, 2.6341, 1.0E-4), new NewBarrierOptionData(BarrierType.UpOut, 105.0, 3.0, Option.Type.Call, 100.0, 100.0, 0.04, 0.08, 0.5, 0.3, 2.4389, 1.0E-4), new NewBarrierOptionData(BarrierType.UpOut, 105.0, 3.0, Option.Type.Call, 110.0, 100.0, 0.04, 0.08, 0.5, 0.3, 2.4315, 1.0E-4), new NewBarrierOptionData(BarrierType.DownIn, 95.0, 3.0, Option.Type.Call, 90.0, 100.0, 0.04, 0.08, 0.5, 0.3, 9.0093, 1.0E-4), new NewBarrierOptionData(BarrierType.DownIn, 95.0, 3.0, Option.Type.Call, 100.0, 100.0, 0.04, 0.08, 0.5, 0.3, 5.137, 1.0E-4), new NewBarrierOptionData(BarrierType.DownIn, 95.0, 3.0, Option.Type.Call, 110.0, 100.0, 0.04, 0.08, 0.5, 0.3, 2.8517, 1.0E-4), new NewBarrierOptionData(BarrierType.DownIn, 100.0, 3.0, Option.Type.Call, 90.0, 100.0, 0.04, 0.08, 0.5, 0.3, 14.8816, 1.0E-4), new NewBarrierOptionData(BarrierType.DownIn, 100.0, 3.0, Option.Type.Call, 100.0, 100.0, 0.04, 0.08, 0.5, 0.3, 9.2045, 1.0E-4), new NewBarrierOptionData(BarrierType.DownIn, 100.0, 3.0, Option.Type.Call, 110.0, 100.0, 0.04, 0.08, 0.5, 0.3, 5.3043, 1.0E-4), new NewBarrierOptionData(BarrierType.UpIn, 105.0, 3.0, Option.Type.Call, 90.0, 100.0, 0.04, 0.08, 0.5, 0.3, 15.2098, 1.0E-4), new NewBarrierOptionData(BarrierType.UpIn, 105.0, 3.0, Option.Type.Call, 100.0, 100.0, 0.04, 0.08, 0.5, 0.3, 9.7278, 1.0E-4), new NewBarrierOptionData(BarrierType.UpIn, 105.0, 3.0, Option.Type.Call, 110.0, 100.0, 0.04, 0.08, 0.5, 0.3, 5.835, 1.0E-4), new NewBarrierOptionData(BarrierType.DownOut, 95.0, 3.0, Option.Type.Put, 90.0, 100.0, 0.04, 0.08, 0.5, 0.25, 2.2798, 1.0E-4), new NewBarrierOptionData(BarrierType.DownOut, 95.0, 3.0, Option.Type.Put, 100.0, 100.0, 0.04, 0.08, 0.5, 0.25, 2.2947, 1.0E-4), new NewBarrierOptionData(BarrierType.DownOut, 95.0, 3.0, Option.Type.Put, 110.0, 100.0, 0.04, 0.08, 0.5, 0.25, 2.6252, 1.0E-4), new NewBarrierOptionData(BarrierType.DownOut, 100.0, 3.0, Option.Type.Put, 90.0, 100.0, 0.04, 0.08, 0.5, 0.25, 3.0, 1.0E-4), new NewBarrierOptionData(BarrierType.DownOut, 100.0, 3.0, Option.Type.Put, 100.0, 100.0, 0.04, 0.08, 0.5, 0.25, 3.0, 1.0E-4), new NewBarrierOptionData(BarrierType.DownOut, 100.0, 3.0, Option.Type.Put, 110.0, 100.0, 0.04, 0.08, 0.5, 0.25, 3.0, 1.0E-4), new NewBarrierOptionData(BarrierType.UpOut, 105.0, 3.0, Option.Type.Put, 90.0, 100.0, 0.04, 0.08, 0.5, 0.25, 3.776, 1.0E-4), new NewBarrierOptionData(BarrierType.UpOut, 105.0, 3.0, Option.Type.Put, 100.0, 100.0, 0.04, 0.08, 0.5, 0.25, 5.4932, 1.0E-4), new NewBarrierOptionData(BarrierType.UpOut, 105.0, 3.0, Option.Type.Put, 110.0, 100.0, 0.04, 0.08, 0.5, 0.25, 7.5187, 1.0E-4), new NewBarrierOptionData(BarrierType.DownIn, 95.0, 3.0, Option.Type.Put, 90.0, 100.0, 0.04, 0.08, 0.5, 0.25, 2.9586, 1.0E-4), new NewBarrierOptionData(BarrierType.DownIn, 95.0, 3.0, Option.Type.Put, 100.0, 100.0, 0.04, 0.08, 0.5, 0.25, 6.5677, 1.0E-4), new NewBarrierOptionData(BarrierType.DownIn, 95.0, 3.0, Option.Type.Put, 110.0, 100.0, 0.04, 0.08, 0.5, 0.25, 11.9752, 1.0E-4), new NewBarrierOptionData(BarrierType.DownIn, 100.0, 3.0, Option.Type.Put, 90.0, 100.0, 0.04, 0.08, 0.5, 0.25, 2.2845, 1.0E-4), new NewBarrierOptionData(BarrierType.DownIn, 100.0, 3.0, Option.Type.Put, 100.0, 100.0, 0.04, 0.08, 0.5, 0.25, 5.9085, 1.0E-4), new NewBarrierOptionData(BarrierType.DownIn, 100.0, 3.0, Option.Type.Put, 110.0, 100.0, 0.04, 0.08, 0.5, 0.25, 11.6465, 1.0E-4), new NewBarrierOptionData(BarrierType.UpIn, 105.0, 3.0, Option.Type.Put, 90.0, 100.0, 0.04, 0.08, 0.5, 0.25, 1.4653, 1.0E-4), new NewBarrierOptionData(BarrierType.UpIn, 105.0, 3.0, Option.Type.Put, 100.0, 100.0, 0.04, 0.08, 0.5, 0.25, 3.3721, 1.0E-4), new NewBarrierOptionData(BarrierType.UpIn, 105.0, 3.0, Option.Type.Put, 110.0, 100.0, 0.04, 0.08, 0.5, 0.25, 7.0846, 1.0E-4), new NewBarrierOptionData(BarrierType.DownOut, 95.0, 3.0, Option.Type.Put, 90.0, 100.0, 0.04, 0.08, 0.5, 0.3, 2.417, 1.0E-4), new NewBarrierOptionData(BarrierType.DownOut, 95.0, 3.0, Option.Type.Put, 100.0, 100.0, 0.04, 0.08, 0.5, 0.3, 2.4258, 1.0E-4), new NewBarrierOptionData(BarrierType.DownOut, 95.0, 3.0, Option.Type.Put, 110.0, 100.0, 0.04, 0.08, 0.5, 0.3, 2.6246, 1.0E-4), new NewBarrierOptionData(BarrierType.DownOut, 100.0, 3.0, Option.Type.Put, 90.0, 100.0, 0.04, 0.08, 0.5, 0.3, 3.0, 1.0E-4), new NewBarrierOptionData(BarrierType.DownOut, 100.0, 3.0, Option.Type.Put, 100.0, 100.0, 0.04, 0.08, 0.5, 0.3, 3.0, 1.0E-4), new NewBarrierOptionData(BarrierType.DownOut, 100.0, 3.0, Option.Type.Put, 110.0, 100.0, 0.04, 0.08, 0.5, 0.3, 3.0, 1.0E-4), new NewBarrierOptionData(BarrierType.UpOut, 105.0, 3.0, Option.Type.Put, 90.0, 100.0, 0.04, 0.08, 0.5, 0.3, 4.2293, 1.0E-4), new NewBarrierOptionData(BarrierType.UpOut, 105.0, 3.0, Option.Type.Put, 100.0, 100.0, 0.04, 0.08, 0.5, 0.3, 5.8032, 1.0E-4), new NewBarrierOptionData(BarrierType.UpOut, 105.0, 3.0, Option.Type.Put, 110.0, 100.0, 0.04, 0.08, 0.5, 0.3, 7.5649, 1.0E-4), new NewBarrierOptionData(BarrierType.DownIn, 95.0, 3.0, Option.Type.Put, 90.0, 100.0, 0.04, 0.08, 0.5, 0.3, 3.8769, 1.0E-4), new NewBarrierOptionData(BarrierType.DownIn, 95.0, 3.0, Option.Type.Put, 100.0, 100.0, 0.04, 0.08, 0.5, 0.3, 7.7989, 1.0E-4), new NewBarrierOptionData(BarrierType.DownIn, 95.0, 3.0, Option.Type.Put, 110.0, 100.0, 0.04, 0.08, 0.5, 0.3, 13.3078, 1.0E-4), new NewBarrierOptionData(BarrierType.DownIn, 100.0, 3.0, Option.Type.Put, 90.0, 100.0, 0.04, 0.08, 0.5, 0.3, 3.3328, 1.0E-4), new NewBarrierOptionData(BarrierType.DownIn, 100.0, 3.0, Option.Type.Put, 100.0, 100.0, 0.04, 0.08, 0.5, 0.3, 7.2636, 1.0E-4), new NewBarrierOptionData(BarrierType.DownIn, 100.0, 3.0, Option.Type.Put, 110.0, 100.0, 0.04, 0.08, 0.5, 0.3, 12.9713, 1.0E-4), new NewBarrierOptionData(BarrierType.UpIn, 105.0, 3.0, Option.Type.Put, 90.0, 100.0, 0.04, 0.08, 0.5, 0.3, 2.0658, 1.0E-4), new NewBarrierOptionData(BarrierType.UpIn, 105.0, 3.0, Option.Type.Put, 100.0, 100.0, 0.04, 0.08, 0.5, 0.3, 4.4226, 1.0E-4), new NewBarrierOptionData(BarrierType.UpIn, 105.0, 3.0, Option.Type.Put, 110.0, 100.0, 0.04, 0.08, 0.5, 0.3, 8.3686, 1.0E-4)};
        Actual360 dc = new Actual360();
        Date today = Date.todaysDate();
        new Settings().setEvaluationDate(today);
        SimpleQuote spot = new SimpleQuote(0.0);
        SimpleQuote qRate = new SimpleQuote(0.0);
        YieldTermStructure qTS = Utilities.flatRate(today, qRate, (DayCounter)dc);
        SimpleQuote rRate = new SimpleQuote(0.0);
        YieldTermStructure rTS = Utilities.flatRate(today, rRate, (DayCounter)dc);
        SimpleQuote vol = new SimpleQuote(0.0);
        BlackVolTermStructure volTS = Utilities.flatVol(today, vol, (DayCounter)dc);
        for (NewBarrierOptionData value : values) {
            Date exDate = today.add(this.timeToDays(value.t));
            EuropeanExercise exercise = new EuropeanExercise(exDate);
            spot.setValue(value.s);
            qRate.setValue(value.q);
            rRate.setValue(value.r);
            vol.setValue(value.v);
            PlainVanillaPayoff payoff = new PlainVanillaPayoff(value.type, value.strike);
            BlackScholesMertonProcess stochProcess = new BlackScholesMertonProcess(new Handle<SimpleQuote>(spot), new Handle<YieldTermStructure>(qTS), new Handle<YieldTermStructure>(rTS), new Handle<BlackVolTermStructure>(volTS));
            AnalyticBarrierEngine engine = new AnalyticBarrierEngine(stochProcess);
            BarrierOption barrierOption = new BarrierOption(value.barrierType, value.barrier, value.rebate, payoff, exercise);
            barrierOption.setPricingEngine(engine);
            double calculated = barrierOption.NPV();
            double expected = value.result;
            double error = Math.abs(calculated - expected);
            if (!(error > value.tol)) continue;
            this.REPORT_FAILURE("value", value.barrierType, value.barrier, value.rebate, payoff, exercise, value.s, value.q, value.r, today, value.v, expected, calculated, error, value.tol);
        }
    }

    @Test
    public void testBabsiriValues() {
        QL.info("Testing barrier options against Babsiri's values...");
        BarrierOptionData[] values = new BarrierOptionData[]{new BarrierOptionData(BarrierType.DownIn, 0.1, 100.0, 90.0, 0.07187, 0.0), new BarrierOptionData(BarrierType.DownIn, 0.15, 100.0, 90.0, 0.60638, 0.0), new BarrierOptionData(BarrierType.DownIn, 0.2, 100.0, 90.0, 1.64005, 0.0), new BarrierOptionData(BarrierType.DownIn, 0.25, 100.0, 90.0, 2.98495, 0.0), new BarrierOptionData(BarrierType.DownIn, 0.3, 100.0, 90.0, 4.50952, 0.0), new BarrierOptionData(BarrierType.UpIn, 0.1, 100.0, 110.0, 4.79148, 0.0), new BarrierOptionData(BarrierType.UpIn, 0.15, 100.0, 110.0, 7.08268, 0.0), new BarrierOptionData(BarrierType.UpIn, 0.2, 100.0, 110.0, 9.11008, 0.0), new BarrierOptionData(BarrierType.UpIn, 0.25, 100.0, 110.0, 11.06148, 0.0), new BarrierOptionData(BarrierType.UpIn, 0.3, 100.0, 110.0, 12.98351, 0.0)};
        double underlyingPrice = 100.0;
        double rebate = 0.0;
        double r = 0.05;
        double q = 0.02;
        Actual360 dc = new Actual360();
        Date today = Date.todaysDate();
        new Settings().setEvaluationDate(today);
        SimpleQuote underlying = new SimpleQuote(100.0);
        SimpleQuote qH_SME = new SimpleQuote(0.02);
        YieldTermStructure qTS = Utilities.flatRate(today, qH_SME, (DayCounter)dc);
        SimpleQuote rH_SME = new SimpleQuote(0.05);
        YieldTermStructure rTS = Utilities.flatRate(today, rH_SME, (DayCounter)dc);
        SimpleQuote volatility = new SimpleQuote(0.1);
        BlackVolTermStructure volTS = Utilities.flatVol(today, volatility, (DayCounter)dc);
        Date exDate = today.add(360);
        EuropeanExercise exercise = new EuropeanExercise(exDate);
        for (BarrierOptionData value : values) {
            volatility.setValue(value.volatility);
            PlainVanillaPayoff callPayoff = new PlainVanillaPayoff(Option.Type.Call, value.strike);
            BlackScholesMertonProcess stochProcess = new BlackScholesMertonProcess(new Handle<SimpleQuote>(underlying), new Handle<YieldTermStructure>(qTS), new Handle<YieldTermStructure>(rTS), new Handle<BlackVolTermStructure>(volTS));
            AnalyticBarrierEngine engine = new AnalyticBarrierEngine(stochProcess);
            BarrierOption barrierCallOption = new BarrierOption(value.barrierType, value.barrier, 0.0, callPayoff, exercise);
            barrierCallOption.setPricingEngine(engine);
            double calculated = barrierCallOption.NPV();
            double expected = value.callValue;
            double error = Math.abs(calculated - expected);
            double maxErrorAllowed = 0.001;
            if (!(error > 0.001)) continue;
            this.REPORT_FAILURE("value", value.barrierType, value.barrier, 0.0, callPayoff, exercise, 100.0, 0.02, 0.05, today, value.volatility, expected, calculated, error, 0.001);
        }
    }

    @Test
    public void testBeagleholeValues() {
        QL.info("Testing barrier options against Beaglehole's values...");
        BarrierOptionData[] values = new BarrierOptionData[]{new BarrierOptionData(BarrierType.DownOut, 0.5, 50.0, 45.0, 5.477, 0.0)};
        double underlyingPrice = 50.0;
        double rebate = 0.0;
        double r = Math.log(1.1);
        double q = 0.0;
        Actual360 dc = new Actual360();
        Date today = Date.todaysDate();
        new Settings().setEvaluationDate(today);
        SimpleQuote underlying = new SimpleQuote(50.0);
        SimpleQuote qH_SME = new SimpleQuote(0.0);
        YieldTermStructure qTS = Utilities.flatRate(today, qH_SME, (DayCounter)dc);
        SimpleQuote rH_SME = new SimpleQuote(r);
        YieldTermStructure rTS = Utilities.flatRate(today, rH_SME, (DayCounter)dc);
        SimpleQuote volatility = new SimpleQuote(0.1);
        BlackVolTermStructure volTS = Utilities.flatVol(today, volatility, (DayCounter)dc);
        Date exDate = today.add(360);
        EuropeanExercise exercise = new EuropeanExercise(exDate);
        for (BarrierOptionData value : values) {
            volatility.setValue(value.volatility);
            PlainVanillaPayoff callPayoff = new PlainVanillaPayoff(Option.Type.Call, value.strike);
            BlackScholesMertonProcess stochProcess = new BlackScholesMertonProcess(new Handle<SimpleQuote>(underlying), new Handle<YieldTermStructure>(qTS), new Handle<YieldTermStructure>(rTS), new Handle<BlackVolTermStructure>(volTS));
            AnalyticBarrierEngine engine = new AnalyticBarrierEngine(stochProcess);
            BarrierOption barrierCallOption = new BarrierOption(value.barrierType, value.barrier, 0.0, callPayoff, exercise);
            barrierCallOption.setPricingEngine(engine);
            double calculated = barrierCallOption.NPV();
            double expected = value.callValue;
            double error = Math.abs(calculated - expected);
            double maxErrorAllowed = 0.001;
            if (!(error > 0.001)) continue;
            this.REPORT_FAILURE("value", value.barrierType, value.barrier, 0.0, callPayoff, exercise, 50.0, 0.0, r, today, value.volatility, expected, calculated, error, 0.001);
        }
    }

    private int timeToDays(double t) {
        return (int)(t * 360.0 + 0.5);
    }

    private void REPORT_FAILURE(String greekName, BarrierType barrierType, double barrier, double rebate, StrikedTypePayoff payoff, Exercise exercise, double s, double q, double r, Date today, double v, double expected, double calculated, double error, double tolerance) {
        Assert.fail((String)("\n" + (Object)((Object)barrierType) + " " + exercise + (Object)((Object)payoff.optionType()) + " option with " + payoff.getClass().getSimpleName() + " payoff:\n" + "    underlying value: " + s + "\n" + "    strike:           " + payoff.strike() + "\n" + "    barrier:          " + barrier + "\n" + "    rebate:           " + rebate + "\n" + "    dividend yield:   " + q + "\n" + "    risk-free rate:   " + r + "\n" + "    reference date:   " + today + "\n" + "    maturity:         " + exercise.lastDate() + "\n" + "    volatility:       " + v + "\n\n" + "    expected   " + greekName + ": " + expected + "\n" + "    calculated " + greekName + ": " + calculated + "\n" + "    error:            " + error + "\n" + "    tolerance:        " + tolerance));
    }

    private static class BarrierOptionData {
        private final BarrierType barrierType;
        private final double volatility;
        private final double strike;
        private final double barrier;
        private final double callValue;
        private final double putValue;

        public BarrierOptionData(BarrierType barrierType, double volatility, double strike, double barrier, double callValue, double putValue) {
            this.barrierType = barrierType;
            this.volatility = volatility;
            this.strike = strike;
            this.barrier = barrier;
            this.callValue = callValue;
            this.putValue = putValue;
        }
    }

    private static class NewBarrierOptionData {
        private final BarrierType barrierType;
        private final double barrier;
        private final double rebate;
        private final Option.Type type;
        private final double strike;
        private final double s;
        private final double q;
        private final double r;
        private final double t;
        private final double v;
        private final double result;
        private final double tol;

        public NewBarrierOptionData(BarrierType barrierType, double barrier, double rebate, Option.Type type, double strike, double s, double q, double r, double t, double v, double result, double tol) {
            this.barrierType = barrierType;
            this.barrier = barrier;
            this.rebate = rebate;
            this.type = type;
            this.strike = strike;
            this.s = s;
            this.q = q;
            this.r = r;
            this.t = t;
            this.v = v;
            this.result = result;
            this.tol = tol;
        }
    }
}

