/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.calendars;

import java.util.ArrayList;
import org.jquantlib.QL;
import org.jquantlib.testsuite.calendars.CalendarUtil;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.calendars.Turkey;
import org.junit.Test;

public class TurkeyCalendarTest {
    private final Calendar exchange;

    public TurkeyCalendarTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
        this.exchange = new Turkey();
    }

    @Test
    public void testTurkeyISEHolidaysYear2004() {
        int year = 2004;
        QL.info("Testing " + this.exchange.name() + " holidays list for the year " + 2004 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2004));
        expectedHol.add(new Date(2, Month.February, 2004));
        expectedHol.add(new Date(3, Month.February, 2004));
        expectedHol.add(new Date(4, Month.February, 2004));
        expectedHol.add(new Date(23, Month.April, 2004));
        expectedHol.add(new Date(19, Month.May, 2004));
        expectedHol.add(new Date(30, Month.August, 2004));
        expectedHol.add(new Date(29, Month.October, 2004));
        expectedHol.add(new Date(15, Month.November, 2004));
        expectedHol.add(new Date(16, Month.November, 2004));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2004);
    }

    @Test
    public void testTurkeyISEHolidaysYear2005() {
        int year = 2005;
        QL.info("Testing " + this.exchange.name() + " holidays list for the year " + 2005 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(19, Month.January, 2005));
        expectedHol.add(new Date(20, Month.January, 2005));
        expectedHol.add(new Date(21, Month.January, 2005));
        expectedHol.add(new Date(19, Month.May, 2005));
        expectedHol.add(new Date(30, Month.August, 2005));
        expectedHol.add(new Date(2, Month.November, 2005));
        expectedHol.add(new Date(3, Month.November, 2005));
        expectedHol.add(new Date(4, Month.November, 2005));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2005);
    }

    @Test
    public void testTurkeyISEHolidaysYear2006() {
        int year = 2006;
        QL.info("Testing " + this.exchange.name() + " holidays list for the year " + 2006 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(9, Month.January, 2006));
        expectedHol.add(new Date(10, Month.January, 2006));
        expectedHol.add(new Date(11, Month.January, 2006));
        expectedHol.add(new Date(12, Month.January, 2006));
        expectedHol.add(new Date(13, Month.January, 2006));
        expectedHol.add(new Date(19, Month.May, 2006));
        expectedHol.add(new Date(30, Month.August, 2006));
        expectedHol.add(new Date(23, Month.October, 2006));
        expectedHol.add(new Date(24, Month.October, 2006));
        expectedHol.add(new Date(25, Month.October, 2006));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2006);
    }

    @Test
    public void testTurkeyISEHolidaysYear2007() {
        int year = 2007;
        QL.info("Testing " + this.exchange.name() + " holidays list for the year " + 2007 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2007));
        expectedHol.add(new Date(2, Month.January, 2007));
        expectedHol.add(new Date(3, Month.January, 2007));
        expectedHol.add(new Date(4, Month.January, 2007));
        expectedHol.add(new Date(23, Month.April, 2007));
        expectedHol.add(new Date(30, Month.August, 2007));
        expectedHol.add(new Date(11, Month.October, 2007));
        expectedHol.add(new Date(12, Month.October, 2007));
        expectedHol.add(new Date(29, Month.October, 2007));
        expectedHol.add(new Date(19, Month.December, 2007));
        expectedHol.add(new Date(20, Month.December, 2007));
        expectedHol.add(new Date(21, Month.December, 2007));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2007);
    }

    @Test
    public void testTurkeyISEHolidaysYear2008() {
        int year = 2008;
        QL.info("Testing " + this.exchange.name() + " holidays list for the year " + 2008 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2008));
        expectedHol.add(new Date(23, Month.April, 2008));
        expectedHol.add(new Date(19, Month.May, 2008));
        expectedHol.add(new Date(29, Month.September, 2008));
        expectedHol.add(new Date(30, Month.September, 2008));
        expectedHol.add(new Date(1, Month.October, 2008));
        expectedHol.add(new Date(2, Month.October, 2008));
        expectedHol.add(new Date(29, Month.October, 2008));
        expectedHol.add(new Date(8, Month.December, 2008));
        expectedHol.add(new Date(9, Month.December, 2008));
        expectedHol.add(new Date(10, Month.December, 2008));
        expectedHol.add(new Date(11, Month.December, 2008));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2008);
    }

    @Test
    public void testTurkeyISEHolidaysYear2009() {
        int year = 2009;
        QL.info("Testing " + this.exchange.name() + " holidays list for the year " + 2009 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2009));
        expectedHol.add(new Date(23, Month.April, 2009));
        expectedHol.add(new Date(19, Month.May, 2009));
        expectedHol.add(new Date(29, Month.October, 2009));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2009);
    }

    @Test
    public void testTurkeyISEHolidaysYear2010() {
        int year = 2010;
        QL.info("Testing " + this.exchange.name() + " holidays list for the year " + 2010 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2010));
        expectedHol.add(new Date(23, Month.April, 2010));
        expectedHol.add(new Date(19, Month.May, 2010));
        expectedHol.add(new Date(30, Month.August, 2010));
        expectedHol.add(new Date(29, Month.October, 2010));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2010);
    }

    @Test
    public void testTurkeyISEHolidaysYear2011() {
        int year = 2011;
        QL.info("Testing " + this.exchange.name() + " holidays list for the year " + 2011 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(19, Month.May, 2011));
        expectedHol.add(new Date(30, Month.August, 2011));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2011);
    }

    @Test
    public void testTurkeyISEHolidaysYear2012() {
        int year = 2012;
        QL.info("Testing " + this.exchange.name() + " holidays list for the year " + 2012 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(23, Month.April, 2012));
        expectedHol.add(new Date(30, Month.August, 2012));
        expectedHol.add(new Date(29, Month.October, 2012));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.exchange, 2012);
    }
}

