/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.calendars;

import java.util.ArrayList;
import org.jquantlib.QL;
import org.jquantlib.testsuite.calendars.CalendarUtil;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.calendars.Japan;
import org.junit.Test;

public class JapanCalendarTest {
    private final Calendar settlement;

    public JapanCalendarTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
        this.settlement = new Japan();
    }

    @Test
    public void testJapanYear2012() {
        int year = 2012;
        QL.info("Testing Japan's holiday list for the year 2012...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(2, Month.January, 2012));
        expectedHol.add(new Date(3, Month.January, 2012));
        expectedHol.add(new Date(9, Month.January, 2012));
        expectedHol.add(new Date(20, Month.March, 2012));
        expectedHol.add(new Date(30, Month.April, 2012));
        expectedHol.add(new Date(3, Month.May, 2012));
        expectedHol.add(new Date(4, Month.May, 2012));
        expectedHol.add(new Date(16, Month.July, 2012));
        expectedHol.add(new Date(17, Month.September, 2012));
        expectedHol.add(new Date(8, Month.October, 2012));
        expectedHol.add(new Date(23, Month.November, 2012));
        expectedHol.add(new Date(24, Month.December, 2012));
        expectedHol.add(new Date(31, Month.December, 2012));
        new CalendarUtil().checkHolidayList(expectedHol, this.settlement, 2012);
    }

    @Test
    public void testJapanYear2011() {
        int year = 2011;
        QL.info("Testing Japan's holiday list for the year 2011...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(3, Month.January, 2011));
        expectedHol.add(new Date(10, Month.January, 2011));
        expectedHol.add(new Date(11, Month.February, 2011));
        expectedHol.add(new Date(21, Month.March, 2011));
        expectedHol.add(new Date(29, Month.April, 2011));
        expectedHol.add(new Date(3, Month.May, 2011));
        expectedHol.add(new Date(4, Month.May, 2011));
        expectedHol.add(new Date(5, Month.May, 2011));
        expectedHol.add(new Date(18, Month.July, 2011));
        expectedHol.add(new Date(19, Month.September, 2011));
        expectedHol.add(new Date(23, Month.September, 2011));
        expectedHol.add(new Date(10, Month.October, 2011));
        expectedHol.add(new Date(3, Month.November, 2011));
        expectedHol.add(new Date(23, Month.November, 2011));
        expectedHol.add(new Date(23, Month.December, 2011));
        new CalendarUtil().checkHolidayList(expectedHol, this.settlement, 2011);
    }

    @Test
    public void testJapanYear2010() {
        int year = 2010;
        QL.info("Testing Japan's holiday list for the year 2010...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2010));
        expectedHol.add(new Date(11, Month.January, 2010));
        expectedHol.add(new Date(11, Month.February, 2010));
        expectedHol.add(new Date(22, Month.March, 2010));
        expectedHol.add(new Date(29, Month.April, 2010));
        expectedHol.add(new Date(3, Month.May, 2010));
        expectedHol.add(new Date(4, Month.May, 2010));
        expectedHol.add(new Date(5, Month.May, 2010));
        expectedHol.add(new Date(19, Month.July, 2010));
        expectedHol.add(new Date(20, Month.September, 2010));
        expectedHol.add(new Date(23, Month.September, 2010));
        expectedHol.add(new Date(11, Month.October, 2010));
        expectedHol.add(new Date(3, Month.November, 2010));
        expectedHol.add(new Date(23, Month.November, 2010));
        expectedHol.add(new Date(23, Month.December, 2010));
        expectedHol.add(new Date(31, Month.December, 2010));
        new CalendarUtil().checkHolidayList(expectedHol, this.settlement, 2010);
    }

    @Test
    public void testJapanYear2009() {
        int year = 2009;
        QL.info("Testing Japan's holiday list for the year 2009...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2009));
        expectedHol.add(new Date(2, Month.January, 2009));
        expectedHol.add(new Date(12, Month.January, 2009));
        expectedHol.add(new Date(11, Month.February, 2009));
        expectedHol.add(new Date(20, Month.March, 2009));
        expectedHol.add(new Date(29, Month.April, 2009));
        expectedHol.add(new Date(4, Month.May, 2009));
        expectedHol.add(new Date(5, Month.May, 2009));
        expectedHol.add(new Date(20, Month.July, 2009));
        expectedHol.add(new Date(21, Month.September, 2009));
        expectedHol.add(new Date(22, Month.September, 2009));
        expectedHol.add(new Date(23, Month.September, 2009));
        expectedHol.add(new Date(12, Month.October, 2009));
        expectedHol.add(new Date(3, Month.November, 2009));
        expectedHol.add(new Date(23, Month.November, 2009));
        expectedHol.add(new Date(23, Month.December, 2009));
        expectedHol.add(new Date(31, Month.December, 2009));
        new CalendarUtil().checkHolidayList(expectedHol, this.settlement, 2009);
    }

    @Test
    public void testJapanYear2008() {
        int year = 2008;
        QL.info("Testing Japan's holiday list for the year 2008...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2008));
        expectedHol.add(new Date(2, Month.January, 2008));
        expectedHol.add(new Date(3, Month.January, 2008));
        expectedHol.add(new Date(14, Month.January, 2008));
        expectedHol.add(new Date(11, Month.February, 2008));
        expectedHol.add(new Date(20, Month.March, 2008));
        expectedHol.add(new Date(29, Month.April, 2008));
        expectedHol.add(new Date(5, Month.May, 2008));
        expectedHol.add(new Date(21, Month.July, 2008));
        expectedHol.add(new Date(15, Month.September, 2008));
        expectedHol.add(new Date(23, Month.September, 2008));
        expectedHol.add(new Date(13, Month.October, 2008));
        expectedHol.add(new Date(3, Month.November, 2008));
        expectedHol.add(new Date(24, Month.November, 2008));
        expectedHol.add(new Date(23, Month.December, 2008));
        expectedHol.add(new Date(31, Month.December, 2008));
        new CalendarUtil().checkHolidayList(expectedHol, this.settlement, 2008);
    }

    @Test
    public void testJapanYear2007() {
        int year = 2007;
        QL.info("Testing Japan's holiday list for the year 2007...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2007));
        expectedHol.add(new Date(2, Month.January, 2007));
        expectedHol.add(new Date(3, Month.January, 2007));
        expectedHol.add(new Date(8, Month.January, 2007));
        expectedHol.add(new Date(12, Month.February, 2007));
        expectedHol.add(new Date(21, Month.March, 2007));
        expectedHol.add(new Date(30, Month.April, 2007));
        expectedHol.add(new Date(3, Month.May, 2007));
        expectedHol.add(new Date(4, Month.May, 2007));
        expectedHol.add(new Date(16, Month.July, 2007));
        expectedHol.add(new Date(17, Month.September, 2007));
        expectedHol.add(new Date(24, Month.September, 2007));
        expectedHol.add(new Date(8, Month.October, 2007));
        expectedHol.add(new Date(23, Month.November, 2007));
        expectedHol.add(new Date(24, Month.December, 2007));
        expectedHol.add(new Date(31, Month.December, 2007));
        new CalendarUtil().checkHolidayList(expectedHol, this.settlement, 2007);
    }

    @Test
    public void testJapanYear2006() {
        int year = 2006;
        QL.info("Testing Japan's holiday list for the year 2006...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(2, Month.January, 2006));
        expectedHol.add(new Date(3, Month.January, 2006));
        expectedHol.add(new Date(9, Month.January, 2006));
        expectedHol.add(new Date(21, Month.March, 2006));
        expectedHol.add(new Date(3, Month.May, 2006));
        expectedHol.add(new Date(4, Month.May, 2006));
        expectedHol.add(new Date(5, Month.May, 2006));
        expectedHol.add(new Date(17, Month.July, 2006));
        expectedHol.add(new Date(18, Month.September, 2006));
        expectedHol.add(new Date(9, Month.October, 2006));
        expectedHol.add(new Date(3, Month.November, 2006));
        expectedHol.add(new Date(23, Month.November, 2006));
        new CalendarUtil().checkHolidayList(expectedHol, this.settlement, 2006);
    }

    @Test
    public void testJapanYear2005() {
        int year = 2005;
        QL.info("Testing Japan's holiday list for the year 2005...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(3, Month.January, 2005));
        expectedHol.add(new Date(10, Month.January, 2005));
        expectedHol.add(new Date(11, Month.February, 2005));
        expectedHol.add(new Date(21, Month.March, 2005));
        expectedHol.add(new Date(29, Month.April, 2005));
        expectedHol.add(new Date(3, Month.May, 2005));
        expectedHol.add(new Date(4, Month.May, 2005));
        expectedHol.add(new Date(5, Month.May, 2005));
        expectedHol.add(new Date(18, Month.July, 2005));
        expectedHol.add(new Date(19, Month.September, 2005));
        expectedHol.add(new Date(23, Month.September, 2005));
        expectedHol.add(new Date(10, Month.October, 2005));
        expectedHol.add(new Date(3, Month.November, 2005));
        expectedHol.add(new Date(23, Month.November, 2005));
        expectedHol.add(new Date(23, Month.December, 2005));
        new CalendarUtil().checkHolidayList(expectedHol, this.settlement, 2005);
    }

    @Test
    public void testJapanYear2004() {
        int year = 2004;
        QL.info("Testing Japan's holiday list for the year 2004...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2004));
        expectedHol.add(new Date(2, Month.January, 2004));
        expectedHol.add(new Date(12, Month.January, 2004));
        expectedHol.add(new Date(11, Month.February, 2004));
        expectedHol.add(new Date(29, Month.April, 2004));
        expectedHol.add(new Date(3, Month.May, 2004));
        expectedHol.add(new Date(4, Month.May, 2004));
        expectedHol.add(new Date(5, Month.May, 2004));
        expectedHol.add(new Date(19, Month.July, 2004));
        expectedHol.add(new Date(20, Month.September, 2004));
        expectedHol.add(new Date(23, Month.September, 2004));
        expectedHol.add(new Date(11, Month.October, 2004));
        expectedHol.add(new Date(3, Month.November, 2004));
        expectedHol.add(new Date(23, Month.November, 2004));
        expectedHol.add(new Date(23, Month.December, 2004));
        expectedHol.add(new Date(31, Month.December, 2004));
        new CalendarUtil().checkHolidayList(expectedHol, this.settlement, 2004);
    }
}

