/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import java.lang.reflect.Constructor;
import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.interpolations.Interpolation;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.termstructures.Bootstrap;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.InterestRate;
import org.jquantlib.termstructures.IterativeBootstrap;
import org.jquantlib.termstructures.RateHelper;
import org.jquantlib.termstructures.yieldcurves.Discount;
import org.jquantlib.termstructures.yieldcurves.ForwardRate;
import org.jquantlib.termstructures.yieldcurves.InterpolatedDiscountCurve;
import org.jquantlib.termstructures.yieldcurves.InterpolatedForwardCurve;
import org.jquantlib.termstructures.yieldcurves.InterpolatedZeroCurve;
import org.jquantlib.termstructures.yieldcurves.PiecewiseCurve;
import org.jquantlib.termstructures.yieldcurves.Traits;
import org.jquantlib.termstructures.yieldcurves.ZeroYield;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.Month;
import org.jquantlib.time.Period;
import org.jquantlib.util.LazyObject;
import org.jquantlib.util.Pair;

public class PiecewiseYieldCurve<T extends Traits, I extends Interpolation.Interpolator, B extends Bootstrap>
extends LazyObject
implements PiecewiseCurve<I> {
    private final Class<T> classT;
    private final Class<I> classI;
    private final Class<B> classB;
    private final Traits.Curve baseCurve;
    private final RateHelper[] instruments;
    private final Handle<Quote>[] jumps;
    private final double accuracy;
    private double[] jumpTimes;
    private Date[] jumpDates;
    private Date latestReference;
    private final Traits traits;
    private final Interpolation.Interpolator interpolator;
    private final Bootstrap bootstrap;

    public PiecewiseYieldCurve(Class<T> classT, Class<I> classI, Class<B> classB, Date referenceDate, RateHelper[] instruments, DayCounter dayCounter) {
        this(classT, classI, classB, referenceDate, instruments, dayCounter, new Handle[0], new Date[0], 1.0E-12, PiecewiseYieldCurve.constructInterpolator(classI), new IterativeBootstrap(PiecewiseYieldCurve.class));
    }

    public PiecewiseYieldCurve(Class<T> classT, Class<I> classI, Class<B> classB, Date referenceDate, RateHelper[] instruments, DayCounter dayCounter, Handle<Quote>[] jumps) {
        this(classT, classI, classB, referenceDate, instruments, dayCounter, jumps, new Date[0], 1.0E-12, PiecewiseYieldCurve.constructInterpolator(classI), new IterativeBootstrap(PiecewiseYieldCurve.class));
    }

    public PiecewiseYieldCurve(Class<T> classT, Class<I> classI, Class<B> classB, Date referenceDate, RateHelper[] instruments, DayCounter dayCounter, Handle<Quote>[] jumps, Date[] jumpDates) {
        this(classT, classI, classB, referenceDate, instruments, dayCounter, jumps, jumpDates, 1.0E-12, PiecewiseYieldCurve.constructInterpolator(classI), new IterativeBootstrap(PiecewiseYieldCurve.class));
    }

    public PiecewiseYieldCurve(Class<T> classT, Class<I> classI, Class<B> classB, Date referenceDate, RateHelper[] instruments, DayCounter dayCounter, Handle<Quote>[] jumps, Date[] jumpDates, double accuracy) {
        this(classT, classI, classB, referenceDate, instruments, dayCounter, jumps, jumpDates, accuracy, PiecewiseYieldCurve.constructInterpolator(classI), new IterativeBootstrap(PiecewiseYieldCurve.class));
    }

    public PiecewiseYieldCurve(Class<T> classT, Class<I> classI, Class<B> classB, Date referenceDate, RateHelper[] instruments, DayCounter dayCounter, Handle<Quote>[] jumps, Date[] jumpDates, double accuracy, Interpolation.Interpolator interpolator) {
        this(classT, classI, classB, referenceDate, instruments, dayCounter, jumps, jumpDates, accuracy, interpolator, new IterativeBootstrap(PiecewiseYieldCurve.class));
    }

    public PiecewiseYieldCurve(Class<T> classT, Class<I> classI, Class<B> classB, Date referenceDate, RateHelper[] instruments, DayCounter dayCounter, Handle<Quote>[] jumps, Date[] jumpDates, double accuracy, Interpolation.Interpolator interpolator, Bootstrap bootstrap) {
        QL.validateExperimentalMode();
        QL.require(classT != null, "Generic type for Traits is null");
        QL.require(classI != null, "Generic type for Interpolation is null");
        QL.require(classB != null, "Generic type for Bootstrap is null");
        this.classT = classT;
        this.classI = classI;
        this.classB = classB;
        this.interpolator = interpolator == null ? PiecewiseYieldCurve.constructInterpolator(classI) : interpolator;
        this.bootstrap = bootstrap == null ? PiecewiseYieldCurve.constructBootstrap(classB) : bootstrap;
        this.baseCurve = PiecewiseYieldCurve.constructBaseClass(classT, classI, referenceDate, dayCounter, this.interpolator);
        this.instruments = instruments;
        this.jumps = jumps == null ? new Handle[]{} : jumps;
        this.jumpDates = jumpDates == null ? new Date[]{} : jumpDates;
        this.accuracy = Double.isNaN(accuracy) ? 1.0E-12 : accuracy;
        this.traits = PiecewiseYieldCurve.constructTraits(classT);
        this.jumpTimes = new double[jumpDates.length];
        this.setJumps();
        for (Handle<Quote> jump : jumps) {
            jump.addObserver(this);
        }
        bootstrap.setup(this);
    }

    public PiecewiseYieldCurve(Class<T> classT, Class<I> classI, Class<B> classB, int settlementDays, Calendar calendar, RateHelper[] instruments, DayCounter dayCounter) {
        this(classT, classI, classB, settlementDays, calendar, instruments, dayCounter, new Handle[0], new Date[0], 1.0E-12, PiecewiseYieldCurve.constructInterpolator(classI), new IterativeBootstrap(PiecewiseYieldCurve.class));
    }

    public PiecewiseYieldCurve(Class<T> classT, Class<I> classI, Class<B> classB, int settlementDays, Calendar calendar, RateHelper[] instruments, DayCounter dayCounter, Handle<Quote>[] jumps) {
        this(classT, classI, classB, settlementDays, calendar, instruments, dayCounter, jumps, new Date[0], 1.0E-12, PiecewiseYieldCurve.constructInterpolator(classI), new IterativeBootstrap(PiecewiseYieldCurve.class));
    }

    public PiecewiseYieldCurve(Class<T> classT, Class<I> classI, Class<B> classB, int settlementDays, Calendar calendar, RateHelper[] instruments, DayCounter dayCounter, Handle<Quote>[] jumps, Date[] jumpDates) {
        this(classT, classI, classB, settlementDays, calendar, instruments, dayCounter, jumps, jumpDates, 1.0E-12, PiecewiseYieldCurve.constructInterpolator(classI), new IterativeBootstrap(PiecewiseYieldCurve.class));
    }

    public PiecewiseYieldCurve(Class<T> classT, Class<I> classI, Class<B> classB, int settlementDays, Calendar calendar, RateHelper[] instruments, DayCounter dayCounter, Handle<Quote>[] jumps, Date[] jumpDates, double accuracy) {
        this(classT, classI, classB, settlementDays, calendar, instruments, dayCounter, jumps, jumpDates, accuracy, PiecewiseYieldCurve.constructInterpolator(classI), new IterativeBootstrap(PiecewiseYieldCurve.class));
    }

    public PiecewiseYieldCurve(Class<T> classT, Class<I> classI, Class<B> classB, int settlementDays, Calendar calendar, RateHelper[] instruments, DayCounter dayCounter, Handle<Quote>[] jumps, Date[] jumpDates, double accuracy, Interpolation.Interpolator interpolator) {
        this(classT, classI, classB, settlementDays, calendar, instruments, dayCounter, jumps, jumpDates, accuracy, interpolator, new IterativeBootstrap(PiecewiseYieldCurve.class));
    }

    public PiecewiseYieldCurve(Class<T> classT, Class<I> classI, Class<B> classB, int settlementDays, Calendar calendar, RateHelper[] instruments, DayCounter dayCounter, Handle<Quote>[] jumps, Date[] jumpDates, double accuracy, Interpolation.Interpolator interpolator, Bootstrap bootstrap) {
        QL.validateExperimentalMode();
        QL.require(classT != null, "Generic type for Traits is null");
        QL.require(classI != null, "Generic type for Interpolation is null");
        QL.require(classB != null, "Generic type for Bootstrap is null");
        this.classT = classT;
        this.classI = classI;
        this.classB = classB;
        this.interpolator = interpolator == null ? PiecewiseYieldCurve.constructInterpolator(classI) : interpolator;
        this.bootstrap = bootstrap == null ? PiecewiseYieldCurve.constructBootstrap(classB) : bootstrap;
        this.baseCurve = PiecewiseYieldCurve.constructBaseClass(classT, classI, settlementDays, calendar, dayCounter, this.interpolator);
        this.instruments = instruments;
        this.jumps = jumps == null ? new Handle[]{} : jumps;
        this.jumpDates = jumpDates == null ? new Date[]{} : jumpDates;
        this.accuracy = Double.isNaN(accuracy) ? 1.0E-12 : accuracy;
        this.traits = PiecewiseYieldCurve.constructTraits(classT);
        this.jumpTimes = new double[jumpDates.length];
        this.setJumps();
        for (Handle<Quote> jump : jumps) {
            jump.addObserver(this);
        }
        bootstrap.setup(this);
    }

    private static Traits.Curve constructBaseClass(Class<?> classT, Class<?> classI, Date referenceDate, DayCounter dayCounter, Interpolation.Interpolator interpolator) {
        if (classT == Discount.class) {
            return new InterpolatedDiscountCurve(classI, referenceDate, dayCounter, interpolator);
        }
        if (classT == ForwardRate.class) {
            return new InterpolatedForwardCurve(classI, referenceDate, dayCounter, interpolator);
        }
        if (classT == ZeroYield.class) {
            return new InterpolatedZeroCurve(classI, referenceDate, dayCounter, interpolator);
        }
        throw new LibraryException("only Discount, ForwardRate and ZeroYield are supported");
    }

    private static Traits.Curve constructBaseClass(Class<?> classT, Class<?> classI, int settlementDays, Calendar calendar, DayCounter dayCounter, Interpolation.Interpolator interpolator) {
        if (classT == Discount.class) {
            return new InterpolatedDiscountCurve(classI, settlementDays, calendar, dayCounter, interpolator);
        }
        if (classT == ForwardRate.class) {
            return new InterpolatedForwardCurve(classI, settlementDays, calendar, dayCounter, interpolator);
        }
        if (classT == ZeroYield.class) {
            return new InterpolatedZeroCurve(classI, settlementDays, calendar, dayCounter, interpolator);
        }
        throw new LibraryException("only Discount, ForwardRate and ZeroYield are supported");
    }

    private static Traits constructTraits(Class<?> classT) {
        if (Traits.class.isAssignableFrom(classT)) {
            try {
                return (Traits)classT.newInstance();
            }
            catch (Exception e) {
                throw new LibraryException("could not instantiate Traits", e);
            }
        }
        throw new LibraryException("not a Traits");
    }

    private static Interpolation.Interpolator constructInterpolator(Class<?> classI) {
        if (Interpolation.Interpolator.class.isAssignableFrom(classI)) {
            try {
                return (Interpolation.Interpolator)classI.newInstance();
            }
            catch (Exception e) {
                throw new LibraryException("could not instantiate Interpolator", e);
            }
        }
        throw new LibraryException("not an Interpolator");
    }

    private static Bootstrap constructBootstrap(Class<?> classB) {
        if (Bootstrap.class.isAssignableFrom(classB)) {
            try {
                Constructor<?> c = classB.getConstructor(Class.class);
                return (Bootstrap)c.newInstance(PiecewiseCurve.class);
            }
            catch (Exception e) {
                throw new LibraryException("could not instantiate Bootstrap", e);
            }
        }
        throw new LibraryException("not a Bootstrap");
    }

    @Override
    public Traits traits() {
        return this.traits;
    }

    @Override
    public Interpolation.Interpolator interpolator() {
        return this.interpolator;
    }

    @Override
    public RateHelper[] instruments() {
        return this.instruments;
    }

    @Override
    public double accuracy() {
        return this.accuracy;
    }

    @Override
    public Date maxDate() {
        this.calculate();
        return this.baseCurve.maxDate();
    }

    @Override
    public double[] times() {
        this.calculate();
        return this.baseCurve.times();
    }

    @Override
    public Date[] dates() {
        this.calculate();
        return this.baseCurve.dates();
    }

    @Override
    public double[] data() {
        this.calculate();
        return this.baseCurve.data();
    }

    @Override
    public List<Pair<Date, Double>> nodes() {
        this.calculate();
        return this.baseCurve.nodes();
    }

    @Override
    public Date[] jumpDates() {
        this.calculate();
        return this.baseCurve.dates();
    }

    @Override
    public double[] jumpTimes() {
        this.calculate();
        return this.baseCurve.times();
    }

    @Override
    public void setData(double[] data) {
        this.baseCurve.setData(data);
    }

    @Override
    public void setDates(Date[] dates) {
        this.baseCurve.setDates(dates);
    }

    @Override
    public void setTimes(double[] times) {
        this.baseCurve.setTimes(times);
    }

    @Override
    public Interpolation interpolation() {
        return this.baseCurve.interpolation();
    }

    @Override
    public void setInterpolation(Interpolation interpolation) {
        this.baseCurve.setInterpolation(interpolation);
    }

    @Override
    public void update() {
        this.baseCurve.update();
        super.update();
        if (this.baseCurve.referenceDate() != this.latestReference) {
            this.setJumps();
        }
    }

    public double discountImpl(double t) {
        this.calculate();
        if (this.jumps.length > 0) {
            double jumpEffect = 1.0;
            for (int i = 0; i < this.jumps.length && this.jumpTimes[i] < t; ++i) {
                QL.require(this.jumps[i].currentLink().isValid(), "invalid jump quote");
                double thisJump = this.jumps[i].currentLink().value();
                QL.require(thisJump > 0.0 && thisJump <= 1.0, "invalid  jump value");
                jumpEffect *= thisJump;
            }
            return jumpEffect * this.baseCurve.discount(t);
        }
        return this.baseCurve.discount(t);
    }

    public void setJumps() {
        int i;
        int nJumps = this.jumps.length;
        Date referenceDate = this.baseCurve.referenceDate();
        if (this.jumpDates.length == 0 && this.jumps.length != 0) {
            this.jumpDates = new Date[nJumps];
            this.jumpTimes = new double[nJumps];
            for (i = 0; i < this.jumps.length; ++i) {
                this.jumpDates[i] = new Date(31, Month.December, referenceDate.year() + i);
            }
        } else {
            QL.require(this.jumpDates.length == nJumps, "mismatch between number of jumps and jump dates");
        }
        for (i = 0; i < nJumps; ++i) {
            this.jumpTimes[i] = this.baseCurve.timeFromReference(this.jumpDates[i]);
        }
        this.latestReference = referenceDate;
    }

    @Override
    public void performCalculations() {
        this.bootstrap.calculate();
    }

    @Override
    public double discount(Date d, boolean extrapolate) {
        return this.baseCurve.discount(d, extrapolate);
    }

    @Override
    public double discount(Date d) {
        return this.baseCurve.discount(d);
    }

    @Override
    public double discount(double t, boolean extrapolate) {
        return this.baseCurve.discount(t, extrapolate);
    }

    @Override
    public double discount(double t) {
        return this.baseCurve.discount(t);
    }

    @Override
    public InterestRate forwardRate(Date d1, Date d2, DayCounter dayCounter, Compounding comp, Frequency freq, boolean extrapolate) {
        return this.baseCurve.forwardRate(d1, d2, dayCounter, comp, freq, extrapolate);
    }

    @Override
    public InterestRate forwardRate(Date d1, Date d2, DayCounter resultDayCounter, Compounding comp, Frequency freq) {
        return this.baseCurve.forwardRate(d1, d2, resultDayCounter, comp, freq);
    }

    @Override
    public InterestRate forwardRate(Date d1, Date d2, DayCounter resultDayCounter, Compounding comp) {
        return this.baseCurve.forwardRate(d1, d2, resultDayCounter, comp);
    }

    @Override
    public InterestRate forwardRate(Date d, Period p, DayCounter dayCounter, Compounding comp, Frequency freq, boolean extrapolate) {
        return this.baseCurve.forwardRate(d, p, dayCounter, comp, freq, extrapolate);
    }

    @Override
    public InterestRate forwardRate(Date d, Period p, DayCounter resultDayCounter, Compounding comp, Frequency freq) {
        return this.baseCurve.forwardRate(d, p, resultDayCounter, comp, freq);
    }

    @Override
    public InterestRate forwardRate(double time1, double time2, Compounding comp, Frequency freq, boolean extrapolate) {
        return this.baseCurve.forwardRate(time1, time2, comp, freq, extrapolate);
    }

    @Override
    public InterestRate forwardRate(double t1, double t2, Compounding comp, Frequency freq) {
        return this.baseCurve.forwardRate(t1, t2, comp, freq);
    }

    @Override
    public InterestRate forwardRate(double t1, double t2, Compounding comp) {
        return this.baseCurve.forwardRate(t1, t2, comp);
    }

    @Override
    public double parRate(Date[] dates, Frequency freq, boolean extrapolate) {
        return this.baseCurve.parRate(dates, freq, extrapolate);
    }

    @Override
    public double parRate(double[] times, Frequency frequency, boolean extrapolate) {
        return this.baseCurve.parRate(times, frequency, extrapolate);
    }

    @Override
    public double parRate(int tenor, Date startDate, Frequency freq, boolean extrapolate) {
        return this.baseCurve.parRate(tenor, startDate, freq, extrapolate);
    }

    @Override
    public InterestRate zeroRate(Date d, DayCounter dayCounter, Compounding comp, Frequency freq, boolean extrapolate) {
        return this.baseCurve.zeroRate(d, dayCounter, comp, freq, extrapolate);
    }

    @Override
    public InterestRate zeroRate(Date d, DayCounter resultDayCounter, Compounding comp, Frequency freq) {
        return this.baseCurve.zeroRate(d, resultDayCounter, comp, freq);
    }

    @Override
    public InterestRate zeroRate(Date d, DayCounter resultDayCounter, Compounding comp) {
        return this.baseCurve.zeroRate(d, resultDayCounter, comp);
    }

    @Override
    public InterestRate zeroRate(double time, Compounding comp, Frequency freq, boolean extrapolate) {
        return this.baseCurve.zeroRate(time, comp, freq, extrapolate);
    }

    @Override
    public Calendar calendar() {
        return this.baseCurve.calendar();
    }

    @Override
    public DayCounter dayCounter() {
        return this.baseCurve.dayCounter();
    }

    @Override
    public double maxTime() {
        return this.baseCurve.maxTime();
    }

    @Override
    public Date referenceDate() {
        return this.baseCurve.referenceDate();
    }

    @Override
    public int settlementDays() {
        return this.baseCurve.settlementDays();
    }

    @Override
    public double timeFromReference(Date date) {
        return this.baseCurve.timeFromReference(date);
    }

    @Override
    public boolean allowsExtrapolation() {
        return this.baseCurve.allowsExtrapolation();
    }

    @Override
    public void disableExtrapolation() {
        this.baseCurve.disableExtrapolation();
    }

    @Override
    public void enableExtrapolation() {
        this.baseCurve.enableExtrapolation();
    }
}

