/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.volatilities;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.LocalVolTermStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.calendars.NullCalendar;

public class LocalConstantVol
extends LocalVolTermStructure {
    private final Handle<Quote> volatility;
    private final DayCounter dayCounter;

    public LocalConstantVol(Date referenceDate, double volatility, DayCounter dayCounter) {
        super(referenceDate);
        this.volatility = new Handle<SimpleQuote>(new SimpleQuote(volatility));
        this.dayCounter = dayCounter;
    }

    public LocalConstantVol(Date referenceDate, Handle<Quote> volatility, DayCounter dayCounter) {
        super(referenceDate);
        this.volatility = volatility;
        this.dayCounter = dayCounter;
        this.volatility.addObserver(this);
    }

    public LocalConstantVol(int settlementDays, Calendar cal, double volatility, DayCounter dayCounter) {
        super(settlementDays, (Calendar)new NullCalendar());
        this.volatility = new Handle<SimpleQuote>(new SimpleQuote(volatility));
        this.dayCounter = dayCounter;
    }

    public LocalConstantVol(int settlementDays, Calendar cal, Handle<Quote> volatility, DayCounter dayCounter) {
        super(settlementDays, (Calendar)new NullCalendar());
        this.volatility = volatility;
        this.dayCounter = dayCounter;
        this.volatility.addObserver(this);
    }

    @Override
    public final DayCounter dayCounter() {
        return this.dayCounter;
    }

    @Override
    public final Date maxDate() {
        return Date.maxDate();
    }

    @Override
    public final double minStrike() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public final double maxStrike() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    protected final double localVolImpl(double maturity, double strike) {
        return this.volatility.currentLink().value();
    }
}

