/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.volatilities;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.BlackVarianceTermStructure;
import org.jquantlib.termstructures.BlackVolTermStructure;
import org.jquantlib.time.Date;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

public class ImpliedVolTermStructure
extends BlackVarianceTermStructure {
    private final Handle<BlackVolTermStructure> originalTS;

    public ImpliedVolTermStructure(Handle<BlackVolTermStructure> originalTS, Date referenceDate) {
        super(referenceDate);
        this.originalTS = originalTS;
        this.originalTS.addObserver(this);
    }

    @Override
    public Date maxDate() {
        return this.originalTS.currentLink().maxDate();
    }

    @Override
    public DayCounter dayCounter() {
        return this.originalTS.currentLink().dayCounter();
    }

    @Override
    protected double blackVarianceImpl(double t, double strike) {
        double timeShift = this.dayCounter().yearFraction(this.originalTS.currentLink().referenceDate(), this.referenceDate());
        return this.originalTS.currentLink().blackForwardVariance(timeShift, timeShift + t, strike, true);
    }

    @Override
    public double maxStrike() {
        return this.originalTS.currentLink().maxStrike();
    }

    @Override
    public double minStrike() {
        return this.originalTS.currentLink().minStrike();
    }

    @Override
    public void accept(PolymorphicVisitor pv) {
        Visitor<?> v;
        Visitor<?> visitor = v = pv != null ? pv.visitor(this.getClass()) : null;
        if (v != null) {
            v.visit(this);
        } else {
            super.accept(pv);
        }
    }
}

