/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures;

import org.jquantlib.QL;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.time.Date;
import org.jquantlib.time.Frequency;

public class InterestRate {
    private final double rate;
    private DayCounter dc;
    private Compounding compound;
    private boolean freqMakesSense;
    private int freq;

    public InterestRate() {
        this.rate = 0.0;
    }

    public InterestRate(double r, DayCounter dc) {
        this(r, dc, Compounding.Continuous);
    }

    public InterestRate(double r, DayCounter dc, Compounding comp) {
        this(r, dc, comp, Frequency.Annual);
    }

    public InterestRate(double r, DayCounter dc, Compounding comp, Frequency freq) {
        this.rate = r;
        this.dc = dc;
        this.compound = comp;
        this.freqMakesSense = false;
        if (this.compound == Compounding.Compounded || this.compound == Compounding.SimpleThenCompounded) {
            this.freqMakesSense = true;
            QL.require(freq != Frequency.Once && freq != Frequency.NoFrequency, "frequency not allowed for this interest rate");
            this.freq = freq.toInteger();
        }
    }

    public final double compoundFactor(double time) {
        double t = time;
        QL.require(t >= 0.0, "negative time not allowed");
        QL.require(!Double.isNaN(this.rate), "null interest rate");
        double r = this.rate;
        if (this.compound == Compounding.Simple) {
            return 1.0 + r * t;
        }
        if (this.compound == Compounding.Compounded) {
            return Math.pow(1.0 + r / (double)this.freq, (double)this.freq * t);
        }
        if (this.compound == Compounding.Continuous) {
            return Math.exp(r * t);
        }
        if (this.compound == Compounding.SimpleThenCompounded) {
            if (t < 1.0 / (double)this.freq) {
                return 1.0 + r * t;
            }
            return Math.pow(1.0 + r / (double)this.freq, (double)this.freq * t);
        }
        throw new LibraryException("unknown compounding convention");
    }

    public final double compoundFactor(Date d1, Date d2) {
        return this.compoundFactor(d1, d2, new Date(), new Date());
    }

    public final double compoundFactor(Date d1, Date d2, Date refStart, Date refEnd) {
        double t = this.dc.yearFraction(d1, d2, refStart, refEnd);
        return this.compoundFactor(t);
    }

    public final DayCounter dayCounter() {
        return this.dc;
    }

    public final Compounding compounding() {
        return this.compound;
    }

    public final Frequency frequency() {
        return this.freqMakesSense ? Frequency.valueOf(this.freq) : Frequency.NoFrequency;
    }

    public final double discountFactor(double t) {
        double factor = this.compoundFactor(t);
        return 1.0 / factor;
    }

    public final double discountFactor(Date d1, Date d2) {
        return this.discountFactor(d1, d2, new Date());
    }

    public final double discountFactor(Date d1, Date d2, Date refStart) {
        return this.discountFactor(d1, d2, refStart, new Date());
    }

    public final double discountFactor(Date d1, Date d2, Date refStart, Date refEnd) {
        double t = this.dc.yearFraction(d1, d2, refStart, refEnd);
        return this.discountFactor(t);
    }

    public final InterestRate equivalentRate(double t, Compounding comp) {
        return this.equivalentRate(t, comp, Frequency.Annual);
    }

    public final InterestRate equivalentRate(double t, Compounding comp, Frequency freq) {
        return InterestRate.impliedRate(this.compoundFactor(t), t, this.dc, comp, freq);
    }

    public final InterestRate equivalentRate(Date d1, Date d2, DayCounter resultDC, Compounding comp) {
        return this.equivalentRate(d1, d2, resultDC, comp, Frequency.Annual);
    }

    public final InterestRate equivalentRate(Date d1, Date d2, DayCounter resultDC, Compounding comp, Frequency freq) {
        QL.require(d1.lt(d2), "d1 later than or equal to d2");
        double t1 = this.dc.yearFraction(d1, d2);
        double t2 = resultDC.yearFraction(d1, d2);
        return InterestRate.impliedRate(this.compoundFactor(t1), t2, resultDC, comp, freq);
    }

    public static InterestRate impliedRate(double c, double time, DayCounter resultDC, Compounding comp, Frequency freq) {
        double rate;
        double t = time;
        double f = freq.toInteger();
        QL.require(c > 0.0, "positive compound factor required");
        QL.require(t > 0.0, "positive time required");
        switch (comp) {
            case Simple: {
                rate = (c - 1.0) / t;
                break;
            }
            case Compounded: {
                rate = (Math.pow(c, 1.0 / (f * t)) - 1.0) * f;
                break;
            }
            case Continuous: {
                rate = Math.log(c) / t;
                break;
            }
            case SimpleThenCompounded: {
                if (t <= 1.0 / f) {
                    rate = (c - 1.0) / t;
                    break;
                }
                rate = (Math.pow(c, 1.0 / (f * t)) - 1.0) * f;
                break;
            }
            default: {
                throw new LibraryException("unknown compounding convention");
            }
        }
        return new InterestRate(rate, resultDC, comp, freq);
    }

    public static InterestRate impliedRate(double compound, double t, DayCounter resultDC, Compounding comp) {
        return InterestRate.impliedRate(compound, t, resultDC, comp, Frequency.Annual);
    }

    public static InterestRate impliedRate(double compound, Date d1, Date d2, DayCounter resultDC, Compounding comp) {
        return InterestRate.impliedRate(compound, d1, d2, resultDC, comp, Frequency.Annual);
    }

    public static InterestRate impliedRate(double compound, Date d1, Date d2, DayCounter resultDC, Compounding comp, Frequency freq) {
        QL.require(d1.le(d2), "d1 later than or equal to d2");
        double t = resultDC.yearFraction(d1, d2);
        return InterestRate.impliedRate(compound, t, resultDC, comp, freq);
    }

    public String toString() {
        if (this.rate == 0.0) {
            return "null interest rate";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.rate).append(' ').append(this.dc).append(' ');
        if (this.compound == Compounding.Simple) {
            sb.append("simple compounding");
        } else if (this.compound == Compounding.Compounded) {
            if (this.freq == Frequency.NoFrequency.toInteger() || this.freq == Frequency.Once.toInteger()) {
                throw new IllegalArgumentException(this.freq + " frequency not allowed for this interest rate");
            }
            sb.append(this.freq + " compounding");
        } else if (this.compound == Compounding.Continuous) {
            sb.append("continuous compounding");
        } else if (this.compound == Compounding.SimpleThenCompounded) {
            if (this.freq == Frequency.NoFrequency.toInteger() || this.freq == Frequency.Once.toInteger()) {
                throw new IllegalArgumentException(this.freq + " frequency not allowed for this interest rate");
            }
            sb.append("simple compounding up to " + 12 / this.freq + " months, then " + this.freq + " compounding");
        } else {
            throw new LibraryException("unknown compounding convention");
        }
        return sb.toString();
    }

    public final double rate() {
        return this.rate;
    }
}

