/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.processes;

import org.jquantlib.math.Constants;
import org.jquantlib.processes.OrnsteinUhlenbeckProcess;
import org.jquantlib.processes.StochasticProcess1D;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.Frequency;

public class HullWhiteProcess
extends StochasticProcess1D {
    protected OrnsteinUhlenbeckProcess process;
    protected Handle<YieldTermStructure> h;
    protected double a;
    protected double sigma;

    public HullWhiteProcess(Handle<YieldTermStructure> h, double a, double sigma) {
        this.process = new OrnsteinUhlenbeckProcess(a, sigma, h.currentLink().forwardRate(0.0, 0.0, Compounding.Continuous, Frequency.NoFrequency).rate());
        this.h = h;
        this.a = a;
        this.sigma = sigma;
    }

    public double a() {
        return this.a;
    }

    public double sigma() {
        return this.sigma;
    }

    public double alpha(double t) {
        double alfa = this.a > Constants.QL_EPSILON ? this.sigma / this.a * (1.0 - Math.exp(-this.a * t)) : this.sigma * t;
        alfa *= 0.5 * alfa;
        return alfa += this.h.currentLink().forwardRate(t, t, Compounding.Continuous, Frequency.NoFrequency).rate();
    }

    @Override
    public double x0() {
        return this.process.x0();
    }

    @Override
    public double drift(double t, double x) {
        double alpha_drift = this.sigma * this.sigma / (2.0 * this.a) * (1.0 - Math.exp(-2.0 * this.a * t));
        double shift = 1.0E-4;
        double f = this.h.currentLink().forwardRate(t, t, Compounding.Continuous, Frequency.NoFrequency).rate();
        double fup = this.h.currentLink().forwardRate(t + 1.0E-4, t + 1.0E-4, Compounding.Continuous, Frequency.NoFrequency).rate();
        double f_prime = (fup - f) / 1.0E-4;
        return this.process.drift(t, x) + (alpha_drift += this.a * f + f_prime);
    }

    @Override
    public double diffusion(double t, double x) {
        return this.process.diffusion(t, x);
    }

    @Override
    public double expectation(double t0, double x0, double dt) {
        return this.process.expectation(t0, x0, dt) + this.alpha(t0 + dt) - this.alpha(t0) * Math.exp(-this.a * dt);
    }

    @Override
    public double stdDeviation(double t0, double x0, double dt) {
        return this.process.stdDeviation(t0, x0, dt);
    }

    @Override
    public double variance(double t0, double x0, double dt) {
        return this.process.variance(t0, x0, dt);
    }
}

