/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.vanilla;

import org.jquantlib.QL;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.instruments.OneAssetOption;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.VanillaOption;
import org.jquantlib.math.Constants;
import org.jquantlib.math.distributions.PoissonDistribution;
import org.jquantlib.pricingengines.AnalyticEuropeanEngine;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.processes.Merton76Process;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.RelinkableHandle;
import org.jquantlib.termstructures.BlackVolTermStructure;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.volatilities.BlackConstantVol;
import org.jquantlib.termstructures.yieldcurves.FlatForward;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;

public class JumpDiffusionEngine
extends VanillaOption.EngineImpl {
    private static final double DEFAULT_RELATIVE_ACCURACY = 1.0E-4;
    private static final int DEFAULT_MAX_ITERATIONS = 100;
    private final Merton76Process process;
    private final OneAssetOption.ArgumentsImpl A;
    private final OneAssetOption.ResultsImpl R;
    private final Option.GreeksImpl greeks;
    private final Option.MoreGreeksImpl moreGreeks;
    private final double relativeAccuracy;
    private final int maxIterations;

    public JumpDiffusionEngine(Merton76Process process) {
        this(process, 1.0E-4, 100);
    }

    public JumpDiffusionEngine(Merton76Process process, double relativeAccuracy) {
        this(process, relativeAccuracy, 100);
    }

    public JumpDiffusionEngine(Merton76Process process, double relativeAccuracy, int maxIterations) {
        this.maxIterations = maxIterations;
        this.relativeAccuracy = relativeAccuracy;
        this.A = (OneAssetOption.ArgumentsImpl)this.arguments_;
        this.R = (OneAssetOption.ResultsImpl)this.results_;
        this.greeks = this.R.greeks();
        this.moreGreeks = this.R.moreGreeks();
        this.process = process;
        this.process.addObserver(this);
    }

    @Override
    public void calculate() {
        int i;
        double weight;
        double jumpSquareVol = this.process.logJumpVolatility().currentLink().value() * this.process.logJumpVolatility().currentLink().value();
        double muPlusHalfSquareVol = this.process.logMeanJump().currentLink().value() + 0.5 * jumpSquareVol;
        double k = Math.exp(muPlusHalfSquareVol) - 1.0;
        double lambda = (k + 1.0) * this.process.jumpIntensity().currentLink().value();
        double variance = this.process.blackVolatility().currentLink().blackVariance(this.A.exercise.lastDate(), 1.0);
        DayCounter voldc = this.process.blackVolatility().currentLink().dayCounter();
        Calendar volcal = this.process.blackVolatility().currentLink().calendar();
        Date volRefDate = this.process.blackVolatility().currentLink().referenceDate();
        double t = voldc.yearFraction(volRefDate, this.A.exercise.lastDate());
        double riskFreeRate = -Math.log(this.process.riskFreeRate().currentLink().discount(this.A.exercise.lastDate())) / t;
        Date rateRefDate = this.process.riskFreeRate().currentLink().referenceDate();
        PoissonDistribution p = new PoissonDistribution(lambda * t);
        Handle<? extends Quote> stateVariable = this.process.stateVariable();
        Handle<YieldTermStructure> dividendTS = this.process.dividendYield();
        RelinkableHandle<YieldTermStructure> riskFreeTS = new RelinkableHandle<YieldTermStructure>(this.process.riskFreeRate().currentLink());
        RelinkableHandle<BlackVolTermStructure> volTS = new RelinkableHandle<BlackVolTermStructure>(this.process.blackVolatility().currentLink());
        GeneralizedBlackScholesProcess bsProcess = new GeneralizedBlackScholesProcess(stateVariable, dividendTS, riskFreeTS, volTS);
        AnalyticEuropeanEngine baseEngine = new AnalyticEuropeanEngine(bsProcess);
        OneAssetOption.ArgumentsImpl baseArguments = (OneAssetOption.ArgumentsImpl)baseEngine.getArguments();
        baseArguments.payoff = this.A.payoff;
        baseArguments.exercise = this.A.exercise;
        baseArguments.validate();
        OneAssetOption.ResultsImpl baseResults = (OneAssetOption.ResultsImpl)baseEngine.getResults();
        this.R.value = 0.0;
        this.greeks.delta = 0.0;
        this.greeks.gamma = 0.0;
        this.greeks.theta = 0.0;
        this.greeks.vega = 0.0;
        this.greeks.rho = 0.0;
        this.greeks.dividendRho = 0.0;
        double lastContribution = 1.0;
        for (i = 0; lastContribution > this.relativeAccuracy && i < this.maxIterations || i < (int)(lambda * t); lastContribution *= weight, ++i) {
            double v = Math.sqrt((variance + (double)i * jumpSquareVol) / t);
            double r = riskFreeRate - this.process.jumpIntensity().currentLink().value() * k + (double)i * muPlusHalfSquareVol / t;
            riskFreeTS.linkTo(new FlatForward(rateRefDate, r, voldc));
            volTS.linkTo(new BlackConstantVol(rateRefDate, volcal, v, voldc));
            baseArguments.validate();
            baseEngine.calculate();
            weight = p.op(i);
            this.R.value += weight * baseResults.value;
            this.greeks.delta += weight * baseResults.greeks().delta;
            this.greeks.gamma += weight * baseResults.greeks().gamma;
            this.greeks.vega += weight * (Math.sqrt(variance / t) / v) * baseResults.greeks().vega;
            double theta_correction = baseResults.greeks().vega * ((double)i * jumpSquareVol / (2.0 * v * t * t)) + baseResults.greeks().rho * (double)i * muPlusHalfSquareVol / (t * t);
            this.greeks.theta += weight * (baseResults.greeks().theta + theta_correction + lambda * baseResults.value);
            if (i != 0) {
                this.greeks.theta -= p.op(i - 1) * lambda * baseResults.value;
            }
            this.greeks.rho += weight * baseResults.greeks().rho;
            this.greeks.dividendRho += weight * baseResults.greeks().dividendRho;
            lastContribution = Math.abs(baseResults.value / (Math.abs(this.R.value) > Constants.QL_EPSILON ? this.R.value : 1.0));
            lastContribution = Math.max(lastContribution, Math.abs(baseResults.greeks().delta / (Math.abs(this.greeks.delta) > Constants.QL_EPSILON ? this.greeks.delta : 1.0)));
            lastContribution = Math.max(lastContribution, Math.abs(baseResults.greeks().gamma / (Math.abs(this.greeks.gamma) > Constants.QL_EPSILON ? this.greeks.gamma : 1.0)));
            lastContribution = Math.max(lastContribution, Math.abs(baseResults.greeks().theta / (Math.abs(this.greeks.theta) > Constants.QL_EPSILON ? this.greeks.theta : 1.0)));
            lastContribution = Math.max(lastContribution, Math.abs(baseResults.greeks().vega / (Math.abs(this.greeks.vega) > Constants.QL_EPSILON ? this.greeks.vega : 1.0)));
            lastContribution = Math.max(lastContribution, Math.abs(baseResults.greeks().rho / (Math.abs(this.greeks.rho) > Constants.QL_EPSILON ? this.greeks.rho : 1.0)));
            lastContribution = Math.max(lastContribution, Math.abs(baseResults.greeks().dividendRho / (Math.abs(this.greeks.dividendRho) > Constants.QL_EPSILON ? this.greeks.dividendRho : 1.0)));
        }
        QL.ensure(i < this.maxIterations, "accuracy not reached");
    }
}

