/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.vanilla;

import java.util.ArrayList;
import java.util.List;
import org.jquantlib.instruments.DiscretizedAsset;
import org.jquantlib.instruments.OneAssetOption;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.processes.StochasticProcess;
import org.jquantlib.time.TimeGrid;

public class DiscretizedVanillaOption
extends DiscretizedAsset {
    private final StochasticProcess process;
    private final OneAssetOption.ArgumentsImpl a;
    private final List<Double> stoppingTimes;

    public DiscretizedVanillaOption(OneAssetOption.Arguments arguments, StochasticProcess process) {
        this(arguments, process, new TimeGrid());
    }

    public DiscretizedVanillaOption(OneAssetOption.Arguments arguments, StochasticProcess process, TimeGrid grid) {
        this.a = (OneAssetOption.ArgumentsImpl)arguments;
        this.process = process;
        int size = this.a.exercise.size();
        this.stoppingTimes = new ArrayList<Double>();
        for (int i = 0; i < size; ++i) {
            this.stoppingTimes.add(i, process.time(this.a.exercise.date(i)));
            if (grid.empty()) continue;
            this.stoppingTimes.add(i, grid.closestTime(this.stoppingTimes.get(i)));
        }
    }

    private void applySpecificCondition() {
        Array grid = this.method().grid(this.time());
        for (int j = 0; j < this.values_.size(); ++j) {
            this.values_.set(j, Math.max(this.values_.get(j), this.a.payoff.get(grid.get(j))));
        }
    }

    @Override
    public void reset(int size) {
        this.values_ = new Array(size);
        this.adjustValues();
    }

    @Override
    public List<Double> mandatoryTimes() {
        return this.stoppingTimes;
    }

    @Override
    protected void postAdjustValuesImpl() {
        double now = this.time();
        switch (this.a.exercise.type()) {
            case American: {
                if (!(now <= this.stoppingTimes.get(1)) || !(now >= this.stoppingTimes.get(0))) break;
                this.applySpecificCondition();
                break;
            }
            case European: {
                if (!this.isOnTime(this.stoppingTimes.get(0))) break;
                this.applySpecificCondition();
                break;
            }
            case Bermudan: {
                for (int i = 0; i < this.stoppingTimes.size(); ++i) {
                    if (!this.isOnTime(this.stoppingTimes.get(i))) continue;
                    this.applySpecificCondition();
                }
                break;
            }
            default: {
                throw new LibraryException("invalid option type");
            }
        }
    }
}

