/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.vanilla;

import org.jquantlib.QL;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.exercise.AmericanExercise;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.OneAssetOption;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.instruments.VanillaOption;
import org.jquantlib.lang.annotation.PackagePrivate;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.distributions.CumulativeNormalDistribution;
import org.jquantlib.pricingengines.BlackCalculator;
import org.jquantlib.pricingengines.BlackFormula;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;

public class BaroneAdesiWhaleyApproximationEngine
extends VanillaOption.EngineImpl {
    private static final String NOT_AN_AMERICAN_OPTION = "not an American Option";
    private static final String NON_AMERICAN_EXERCISE_GIVEN = "non-American exercise given";
    private static final String PAYOFF_AT_EXPIRY_NOT_HANDLED = "payoff at expiry not handled";
    private static final String NON_STRIKE_PAYOFF_GIVEN = "non-striked payoff given";
    private static final String BLACK_SCHOLES_PROCESS_REQUIRED = "Black-Scholes process required";
    private static final String UNKNOWN_OPTION_TYPE = "unknown Option type";
    private final GeneralizedBlackScholesProcess process;
    private final OneAssetOption.ArgumentsImpl a;
    private final OneAssetOption.ResultsImpl r;
    private final Option.GreeksImpl greeks;
    private final Option.MoreGreeksImpl moreGreeks;

    public BaroneAdesiWhaleyApproximationEngine(GeneralizedBlackScholesProcess process) {
        this.a = (OneAssetOption.ArgumentsImpl)this.arguments_;
        this.r = (OneAssetOption.ResultsImpl)this.results_;
        this.greeks = this.r.greeks();
        this.moreGreeks = this.r.moreGreeks();
        this.process = process;
        this.process.addObserver(this);
    }

    @Override
    public void calculate() {
        QL.require(this.a.exercise.type() == Exercise.Type.American, NOT_AN_AMERICAN_OPTION);
        QL.require(this.a.exercise instanceof AmericanExercise, NON_AMERICAN_EXERCISE_GIVEN);
        AmericanExercise ex = (AmericanExercise)this.a.exercise;
        QL.require(!ex.payoffAtExpiry(), PAYOFF_AT_EXPIRY_NOT_HANDLED);
        QL.require(this.a.payoff instanceof StrikedTypePayoff, NON_STRIKE_PAYOFF_GIVEN);
        StrikedTypePayoff payoff = (StrikedTypePayoff)this.a.payoff;
        double variance = this.process.blackVolatility().currentLink().blackVariance(ex.lastDate(), payoff.strike());
        double dividendDiscount = this.process.dividendYield().currentLink().discount(ex.lastDate());
        double riskFreeDiscount = this.process.riskFreeRate().currentLink().discount(ex.lastDate());
        double spot = this.process.stateVariable().currentLink().value();
        QL.require(spot > 0.0, "negative or null underlying given");
        double forwardPrice = spot * dividendDiscount / riskFreeDiscount;
        BlackCalculator black = new BlackCalculator(payoff, forwardPrice, Math.sqrt(variance), riskFreeDiscount);
        if (dividendDiscount >= 1.0 && payoff.optionType() == Option.Type.Call) {
            this.r.value = black.value();
            this.greeks.delta = black.delta(spot);
            this.moreGreeks.deltaForward = black.deltaForward();
            this.moreGreeks.elasticity = black.elasticity(spot);
            this.greeks.gamma = black.gamma(spot);
            DayCounter rfdc = this.process.riskFreeRate().currentLink().dayCounter();
            DayCounter divdc = this.process.dividendYield().currentLink().dayCounter();
            DayCounter voldc = this.process.blackVolatility().currentLink().dayCounter();
            double t = rfdc.yearFraction(this.process.riskFreeRate().currentLink().referenceDate(), this.a.exercise.lastDate());
            this.greeks.rho = black.rho(t);
            t = divdc.yearFraction(this.process.dividendYield().currentLink().referenceDate(), this.a.exercise.lastDate());
            this.greeks.dividendRho = black.dividendRho(t);
            t = voldc.yearFraction(this.process.blackVolatility().currentLink().referenceDate(), this.a.exercise.lastDate());
            this.greeks.vega = black.vega(t);
            this.greeks.theta = black.theta(spot, t);
            this.moreGreeks.thetaPerDay = black.thetaPerDay(spot, t);
            this.moreGreeks.strikeSensitivity = black.strikeSensitivity();
            this.moreGreeks.itmCashProbability = black.itmCashProbability();
        } else {
            CumulativeNormalDistribution cumNormalDist = new CumulativeNormalDistribution();
            double tolerance = 1.0E-6;
            double Sk = BaroneAdesiWhaleyApproximationEngine.criticalPrice(payoff, riskFreeDiscount, dividendDiscount, variance, 1.0E-6);
            double forwardSk = Sk * dividendDiscount / riskFreeDiscount;
            double d1 = (Math.log(forwardSk / payoff.strike()) + 0.5 * variance) / Math.sqrt(variance);
            double n = 2.0 * Math.log(dividendDiscount / riskFreeDiscount) / variance;
            double K = -2.0 * Math.log(riskFreeDiscount) / (variance * (1.0 - riskFreeDiscount));
            switch (payoff.optionType()) {
                case Call: {
                    double Q = (-(n - 1.0) + Math.sqrt((n - 1.0) * (n - 1.0) + 4.0 * K)) / 2.0;
                    double a = Sk / Q * (1.0 - dividendDiscount * cumNormalDist.op(d1));
                    if (spot < Sk) {
                        this.r.value = black.value() + a * Math.pow(spot / Sk, Q);
                        break;
                    }
                    this.r.value = spot - payoff.strike();
                    break;
                }
                case Put: {
                    double Q = (-(n - 1.0) - Math.sqrt((n - 1.0) * (n - 1.0) + 4.0 * K)) / 2.0;
                    double a = -(Sk / Q) * (1.0 - dividendDiscount * cumNormalDist.op(-d1));
                    if (spot > Sk) {
                        this.r.value = black.value() + a * Math.pow(spot / Sk, Q);
                        break;
                    }
                    this.r.value = payoff.strike() - spot;
                    break;
                }
                default: {
                    throw new LibraryException(UNKNOWN_OPTION_TYPE);
                }
            }
        }
    }

    @Deprecated
    private double criticalPrice(StrikedTypePayoff payoff, double riskFreeDiscount, double dividendDiscount, double variance) {
        return BaroneAdesiWhaleyApproximationEngine.criticalPrice(payoff, riskFreeDiscount, dividendDiscount, variance, 1.0E-6);
    }

    @PackagePrivate
    static double criticalPrice(StrikedTypePayoff payoff, double riskFreeDiscount, double dividendDiscount, double variance, double tolerance) {
        double Si;
        double n = 2.0 * Math.log(dividendDiscount / riskFreeDiscount) / variance;
        double m = -2.0 * Math.log(riskFreeDiscount) / variance;
        double bT = Math.log(dividendDiscount / riskFreeDiscount);
        switch (payoff.optionType()) {
            case Call: {
                double qu = (-(n - 1.0) + Math.sqrt((n - 1.0) * (n - 1.0) + 4.0 * m)) / 2.0;
                double Su = payoff.strike() / (1.0 - 1.0 / qu);
                double h = -(bT + 2.0 * Math.sqrt(variance)) * payoff.strike() / (Su - payoff.strike());
                Si = payoff.strike() + (Su - payoff.strike()) * (1.0 - Math.exp(h));
                break;
            }
            case Put: {
                double qu = (-(n - 1.0) - Math.sqrt((n - 1.0) * (n - 1.0) + 4.0 * m)) / 2.0;
                double Su = payoff.strike() / (1.0 - 1.0 / qu);
                double h = (bT - 2.0 * Math.sqrt(variance)) * payoff.strike() / (payoff.strike() - Su);
                Si = Su + (payoff.strike() - Su) * Math.exp(h);
                break;
            }
            default: {
                throw new LibraryException(UNKNOWN_OPTION_TYPE);
            }
        }
        double forwardSi = Si * dividendDiscount / riskFreeDiscount;
        double d1 = (Math.log(forwardSi / payoff.strike()) + 0.5 * variance) / Math.sqrt(variance);
        CumulativeNormalDistribution cumNormalDist = new CumulativeNormalDistribution();
        double K = riskFreeDiscount != 1.0 ? -2.0 * Math.log(riskFreeDiscount) / (variance * (1.0 - riskFreeDiscount)) : 0.0;
        double temp = BlackFormula.blackFormula(payoff.optionType(), payoff.strike(), forwardSi, Math.sqrt(variance)) * riskFreeDiscount;
        switch (payoff.optionType()) {
            case Call: {
                double Q = (-(n - 1.0) + Math.sqrt((n - 1.0) * (n - 1.0) + 4.0 * K)) / 2.0;
                double LHS = Si - payoff.strike();
                double RHS = temp + (1.0 - dividendDiscount * cumNormalDist.op(d1)) * Si / Q;
                double bi = dividendDiscount * cumNormalDist.op(d1) * (1.0 - 1.0 / Q) + (1.0 - dividendDiscount * cumNormalDist.derivative(d1) / Math.sqrt(variance)) / Q;
                while (Math.abs(LHS - RHS) / payoff.strike() > tolerance) {
                    Si = (payoff.strike() + RHS - bi * Si) / (1.0 - bi);
                    forwardSi = Si * dividendDiscount / riskFreeDiscount;
                    d1 = (Math.log(forwardSi / payoff.strike()) + 0.5 * variance) / Math.sqrt(variance);
                    LHS = Si - payoff.strike();
                    double temp2 = BlackFormula.blackFormula(payoff.optionType(), payoff.strike(), forwardSi, Math.sqrt(variance)) * riskFreeDiscount;
                    RHS = temp2 + (1.0 - dividendDiscount * cumNormalDist.op(d1)) * Si / Q;
                    bi = dividendDiscount * cumNormalDist.op(d1) * (1.0 - 1.0 / Q) + (1.0 - dividendDiscount * cumNormalDist.derivative(d1) / Math.sqrt(variance)) / Q;
                }
                break;
            }
            case Put: {
                double Q = (-(n - 1.0) - Math.sqrt((n - 1.0) * (n - 1.0) + 4.0 * K)) / 2.0;
                double LHS = payoff.strike() - Si;
                double RHS = temp - (1.0 - dividendDiscount * cumNormalDist.op(-d1)) * Si / Q;
                double bi = -dividendDiscount * cumNormalDist.op(-d1) * (1.0 - 1.0 / Q) - (1.0 + dividendDiscount * cumNormalDist.derivative(-d1) / Math.sqrt(variance)) / Q;
                while (Math.abs(LHS - RHS) / payoff.strike() > tolerance) {
                    Si = (payoff.strike() - RHS + bi * Si) / (1.0 + bi);
                    forwardSi = Si * dividendDiscount / riskFreeDiscount;
                    d1 = (Math.log(forwardSi / payoff.strike()) + 0.5 * variance) / Math.sqrt(variance);
                    LHS = payoff.strike() - Si;
                    double temp2 = BlackFormula.blackFormula(payoff.optionType(), payoff.strike(), forwardSi, Math.sqrt(variance)) * riskFreeDiscount;
                    RHS = temp2 - (1.0 - dividendDiscount * cumNormalDist.op(-d1)) * Si / Q;
                    bi = -dividendDiscount * cumNormalDist.op(-d1) * (1.0 - 1.0 / Q) - (1.0 + dividendDiscount * cumNormalDist.derivative(-d1) / Math.sqrt(variance)) / Q;
                }
                break;
            }
            default: {
                throw new LibraryException(UNKNOWN_OPTION_TYPE);
            }
        }
        return Si;
    }
}

