/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.asian;

import java.util.ArrayList;
import org.jquantlib.QL;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.AverageType;
import org.jquantlib.instruments.DiscreteAveragingAsianOption;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.math.Constants;
import org.jquantlib.math.distributions.CumulativeNormalDistribution;
import org.jquantlib.math.distributions.NormalDistribution;
import org.jquantlib.pricingengines.BlackCalculator;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.time.Date;
import org.jquantlib.time.Frequency;

public class AnalyticDiscreteGeometricAveragePriceAsianEngine
extends DiscreteAveragingAsianOption.EngineImpl {
    private static final String NOT_AN_EUROPEAN_OPTION = "not an European Option";
    private static final String NON_STRIKED_PAYOFF_GIVEN = "non-striked payoff given";
    private static final String BLACK_SCHOLES_PROCESS_REQUIRED = "Black-Scholes process required";
    private final GeneralizedBlackScholesProcess process;
    private final DiscreteAveragingAsianOption.ArgumentsImpl a;
    private final DiscreteAveragingAsianOption.ResultsImpl r;
    private final Option.GreeksImpl greeks;
    private final Option.MoreGreeksImpl moreGreeks;

    public AnalyticDiscreteGeometricAveragePriceAsianEngine(GeneralizedBlackScholesProcess process) {
        this.process = process;
        this.a = (DiscreteAveragingAsianOption.ArgumentsImpl)this.arguments_;
        this.r = (DiscreteAveragingAsianOption.ResultsImpl)this.results_;
        this.greeks = this.r.greeks();
        this.moreGreeks = this.r.moreGreeks();
        process.addObserver(this);
    }

    @Override
    public void calculate() {
        double nx_1;
        double Nx_1;
        int i;
        int pastFixings;
        double runningLog;
        QL.require(this.a.exercise.type() == Exercise.Type.European, NOT_AN_EUROPEAN_OPTION);
        StrikedTypePayoff payoff = (StrikedTypePayoff)this.a.payoff;
        QL.require(this.a.payoff instanceof StrikedTypePayoff, NON_STRIKED_PAYOFF_GIVEN);
        if (this.a.averageType == AverageType.Geometric) {
            if (!(this.a.runningAccumulator > 0.0)) {
                throw new IllegalArgumentException("positive running product required: " + this.a.runningAccumulator + " not allowed");
            }
            runningLog = Math.log(this.a.runningAccumulator);
            pastFixings = this.a.pastFixings;
        } else {
            runningLog = 1.0;
            pastFixings = 0;
        }
        Date referenceDate = this.process.riskFreeRate().currentLink().referenceDate();
        DayCounter rfdc = this.process.riskFreeRate().currentLink().dayCounter();
        DayCounter divdc = this.process.dividendYield().currentLink().dayCounter();
        DayCounter voldc = this.process.blackVolatility().currentLink().dayCounter();
        ArrayList<Double> fixingTimes = new ArrayList<Double>();
        for (i = 0; i < this.a.fixingDates.size(); ++i) {
            if (!this.a.fixingDates.get(i).ge(referenceDate)) continue;
            double t = voldc.yearFraction(referenceDate, this.a.fixingDates.get(i));
            fixingTimes.add(t);
        }
        int remainingFixings = fixingTimes.size();
        int numberOfFixings = pastFixings + remainingFixings;
        double N = numberOfFixings;
        double pastWeight = (double)pastFixings / N;
        double futureWeight = 1.0 - pastWeight;
        double timeSum = 0.0;
        for (int k = 0; k < fixingTimes.size(); ++k) {
            timeSum += ((Double)fixingTimes.get(k)).doubleValue();
        }
        double vola = this.process.blackVolatility().currentLink().blackVol(this.a.exercise.lastDate(), payoff.strike());
        double temp = 0.0;
        for (i = pastFixings + 1; i < numberOfFixings; ++i) {
            temp += (Double)fixingTimes.get(i - pastFixings - 1) * (N - (double)i);
        }
        double variance = vola * vola / N / N * (timeSum + 2.0 * temp);
        double dsigG_dsig = Math.sqrt(timeSum + 2.0 * temp) / N;
        double sigG = vola * dsigG_dsig;
        double dmuG_dsig = -(vola * timeSum) / N;
        Date exDate = this.a.exercise.lastDate();
        double dividendRate = this.process.dividendYield().currentLink().zeroRate(exDate, divdc, Compounding.Continuous, Frequency.NoFrequency).rate();
        double riskFreeRate = this.process.riskFreeRate().currentLink().zeroRate(exDate, rfdc, Compounding.Continuous, Frequency.NoFrequency).rate();
        double nu = riskFreeRate - dividendRate - 0.5 * vola * vola;
        double s = this.process.stateVariable().currentLink().value();
        double muG = pastWeight * runningLog + futureWeight * Math.log(s) + nu * timeSum / N;
        double forwardPrice = Math.exp(muG + variance / 2.0);
        double riskFreeDiscount = this.process.riskFreeRate().currentLink().discount(this.a.exercise.lastDate());
        BlackCalculator black = new BlackCalculator(payoff, forwardPrice, Math.sqrt(variance), riskFreeDiscount);
        this.r.value = black.value();
        this.greeks.delta = futureWeight * black.delta(forwardPrice) * forwardPrice / s;
        this.greeks.gamma = forwardPrice * futureWeight / (s * s) * (black.gamma(forwardPrice) * futureWeight * forwardPrice - pastWeight * black.delta(forwardPrice));
        CumulativeNormalDistribution CND = new CumulativeNormalDistribution();
        NormalDistribution ND = new NormalDistribution();
        if (sigG > Constants.QL_EPSILON) {
            double x_1 = (muG - Math.log(payoff.strike()) + variance) / sigG;
            Nx_1 = CND.op(x_1);
            nx_1 = ND.op(x_1);
        } else {
            Nx_1 = muG > Math.log(payoff.strike()) ? 1.0 : 0.0;
            nx_1 = 0.0;
        }
        this.greeks.vega = forwardPrice * riskFreeDiscount * ((dmuG_dsig + sigG * dsigG_dsig) * Nx_1 + nx_1 * dsigG_dsig);
        if (payoff.optionType() == Option.Type.Put) {
            this.greeks.vega -= riskFreeDiscount * forwardPrice * (dmuG_dsig + sigG * dsigG_dsig);
        }
        double tRho = rfdc.yearFraction(this.process.riskFreeRate().currentLink().referenceDate(), this.a.exercise.lastDate());
        this.greeks.rho = black.rho(tRho) * timeSum / (N * tRho) - (tRho - timeSum / N) * this.r.value;
        double tDiv = divdc.yearFraction(this.process.dividendYield().currentLink().referenceDate(), this.a.exercise.lastDate());
        this.greeks.dividendRho = black.dividendRho(tDiv) * timeSum / (N * tDiv);
        this.moreGreeks.strikeSensitivity = black.strikeSensitivity();
        this.greeks.theta = this.greeks.blackScholesTheta(this.process, this.r.value, this.greeks.delta, this.greeks.gamma);
    }
}

