/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines;

import org.jquantlib.QL;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.OneAssetOption;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.pricingengines.BlackCalculator;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.time.Date;

public class AnalyticEuropeanEngine
extends OneAssetOption.EngineImpl {
    private static final String NOT_AN_EUROPEAN_OPTION = "not an European Option";
    private static final String NON_STRIKED_PAYOFF_GIVEN = "non-striked payoff given";
    private static final String BLACK_SCHOLES_PROCESS_REQUIRED = "Black-Scholes process required";
    private final GeneralizedBlackScholesProcess process;
    private final OneAssetOption.ArgumentsImpl a;
    private final OneAssetOption.ResultsImpl r;
    private final Option.GreeksImpl greeks;
    private final Option.MoreGreeksImpl moreGreeks;

    public AnalyticEuropeanEngine(GeneralizedBlackScholesProcess process) {
        this.a = (OneAssetOption.ArgumentsImpl)this.arguments_;
        this.r = (OneAssetOption.ResultsImpl)this.results_;
        this.greeks = this.r.greeks();
        this.moreGreeks = this.r.moreGreeks();
        this.process = process;
        this.process.addObserver(this);
    }

    @Override
    public void calculate() {
        QL.require(this.a.exercise.type() == Exercise.Type.European, NOT_AN_EUROPEAN_OPTION);
        StrikedTypePayoff payoff = (StrikedTypePayoff)this.a.payoff;
        QL.require(payoff != null, NON_STRIKED_PAYOFF_GIVEN);
        double variance = this.process.blackVolatility().currentLink().blackVariance(this.a.exercise.lastDate(), payoff.strike());
        double dividendDiscount = this.process.dividendYield().currentLink().discount(this.a.exercise.lastDate());
        double riskFreeDiscount = this.process.riskFreeRate().currentLink().discount(this.a.exercise.lastDate());
        double spot = this.process.stateVariable().currentLink().value();
        QL.require(spot > 0.0, "negative or null underlying given");
        double forwardPrice = spot * dividendDiscount / riskFreeDiscount;
        BlackCalculator black = new BlackCalculator(payoff, forwardPrice, Math.sqrt(variance), riskFreeDiscount);
        this.r.value = black.value();
        this.greeks.delta = black.delta(spot);
        this.moreGreeks.deltaForward = black.deltaForward();
        this.moreGreeks.elasticity = black.elasticity(spot);
        this.greeks.gamma = black.gamma(spot);
        DayCounter rfdc = this.process.riskFreeRate().currentLink().dayCounter();
        DayCounter divdc = this.process.dividendYield().currentLink().dayCounter();
        DayCounter voldc = this.process.blackVolatility().currentLink().dayCounter();
        Date refDate = this.process.riskFreeRate().currentLink().referenceDate();
        double t = rfdc.yearFraction(refDate, this.a.exercise.lastDate());
        this.greeks.rho = black.rho(t);
        t = divdc.yearFraction(this.process.dividendYield().currentLink().referenceDate(), this.a.exercise.lastDate());
        this.greeks.dividendRho = black.dividendRho(t);
        t = voldc.yearFraction(this.process.blackVolatility().currentLink().referenceDate(), this.a.exercise.lastDate());
        this.greeks.vega = black.vega(t);
        try {
            this.greeks.theta = black.theta(spot, t);
            this.moreGreeks.thetaPerDay = black.thetaPerDay(spot, t);
        }
        catch (Exception e) {
            this.greeks.theta = Double.NaN;
            this.moreGreeks.thetaPerDay = Double.NaN;
        }
        this.moreGreeks.strikeSensitivity = black.strikeSensitivity();
        this.moreGreeks.itmCashProbability = black.itmCashProbability();
    }
}

