/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model.volatility;

import org.jquantlib.lang.iterators.Iterables;
import org.jquantlib.math.IntervalPrice;
import org.jquantlib.model.volatility.LocalVolatilityEstimator;
import org.jquantlib.time.Date;
import org.jquantlib.time.TimeSeries;

public abstract class GarmanKlassAbstract
implements LocalVolatilityEstimator<IntervalPrice> {
    private final double yearFraction;

    public GarmanKlassAbstract(double y) {
        this.yearFraction = y;
    }

    @Override
    public TimeSeries<Double> calculate(TimeSeries<IntervalPrice> quotes) {
        TimeSeries<Double> retval = new TimeSeries<Double>(Double.class);
        for (Date date : Iterables.unmodifiableIterable(quotes.navigableKeySet())) {
            IntervalPrice curr = (IntervalPrice)quotes.get(date);
            retval.put(date, Math.sqrt(Math.abs(this.calculatePoint(curr)) / this.yearFraction));
        }
        return retval;
    }

    public double getYearFraction() {
        return this.yearFraction;
    }

    protected abstract double calculatePoint(IntervalPrice var1);
}

