/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model.shortrate.twofactormodels;

import java.util.ArrayList;
import java.util.List;
import org.jquantlib.instruments.Option;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.math.Ops;
import org.jquantlib.math.distributions.CumulativeNormalDistribution;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.solvers1D.Brent;
import org.jquantlib.model.AffineModel;
import org.jquantlib.model.Parameter;
import org.jquantlib.model.TermStructureFittingParameter;
import org.jquantlib.model.shortrate.onefactormodels.TermStructureConsistentModel;
import org.jquantlib.model.shortrate.onefactormodels.TermStructureConsistentModelClass;
import org.jquantlib.model.shortrate.twofactormodels.TwoFactorModel;
import org.jquantlib.pricingengines.BlackFormula;
import org.jquantlib.processes.OrnsteinUhlenbeckProcess;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.Frequency;

@QualityAssurance(quality=QualityAssurance.Quality.Q0_UNFINISHED, version=QualityAssurance.Version.V097, reviewers={"Richard Gomes"})
public class G2
extends TwoFactorModel
implements AffineModel,
TermStructureConsistentModel {
    private static final String g2_model_needs_two_factors = "g2 model needs two factors to compute discount bond";
    private final TermStructureConsistentModelClass termStructureConsistentModelClass;
    private final Parameter a_;
    private final Parameter sigma_;
    private final Parameter b_;
    private final Parameter eta_;
    private final Parameter rho_;
    private Parameter phi_;

    public G2(Handle<YieldTermStructure> termStructure) {
        this(termStructure, 0.1, 0.01, 0.1, 0.01, -0.75);
    }

    public G2(Handle<YieldTermStructure> termStructure, double a) {
        this(termStructure, a, 0.01, 0.1, 0.01, -0.75);
    }

    public G2(Handle<YieldTermStructure> termStructure, double a, double sigma) {
        this(termStructure, a, sigma, 0.1, 0.01, -0.75);
    }

    public G2(Handle<YieldTermStructure> termStructure, double a, double sigma, double b) {
        this(termStructure, a, sigma, b, 0.01, -0.75);
    }

    public G2(Handle<YieldTermStructure> termStructure, double a, double sigma, double b, double eta) {
        this(termStructure, a, sigma, b, eta, -0.75);
    }

    public G2(Handle<YieldTermStructure> termStructure, double a, double sigma, double b, double eta, double rho) {
        super(5);
        throw new UnsupportedOperationException("Work in progress");
    }

    public double discountBond(double t, double T, double x, double y) {
        return this.A(t, T) * Math.exp(-this.B(this.a(), T - t) * x - this.B(this.b(), T - t) * y);
    }

    @Override
    public double discountBondOption(Option.Type type, double strike, double maturity, double bondMaturity) {
        double v = this.sigmaP(maturity, bondMaturity);
        double f = this.termStructureConsistentModelClass.termStructure().currentLink().discount(bondMaturity);
        double k = this.termStructureConsistentModelClass.termStructure().currentLink().discount(maturity) * strike;
        return BlackFormula.blackFormula(type, k, f, v);
    }

    @Override
    public TwoFactorModel.ShortRateDynamics dynamics() {
        return new Dynamics(this.phi_, this.a(), this.sigma(), this.b(), this.eta(), this.rho());
    }

    public double swaption(Object object, double range, int intervals) {
        throw new UnsupportedOperationException("work in progress");
    }

    @Override
    public double discount(double t) {
        return this.termStructure().currentLink().discount(t);
    }

    @Override
    public void generateArguments() {
        this.phi_ = new FittingParameter(this.termStructureConsistentModelClass.termStructure(), this.a(), this.sigma(), this.b(), this.eta(), this.rho());
    }

    protected double A(double t, double T) {
        return this.termStructureConsistentModelClass.termStructure().currentLink().discount(T) / this.termStructureConsistentModelClass.termStructure().currentLink().discount(t) * Math.exp(0.5 * (this.V(T - t) - this.V(T) + this.V(t)));
    }

    protected double B(double x, double t) {
        return (1.0 - Math.exp(-x * t)) / x;
    }

    private double V(double t) {
        double expat = Math.exp(-this.a() * t);
        double expbt = Math.exp(-this.b() * t);
        double cx = this.sigma() / this.a();
        double cy = this.eta() / this.b();
        double valuex = cx * cx * (t + (2.0 * expat - 0.5 * expat * expat - 1.5) / this.a());
        double valuey = cy * cy * (t + (2.0 * expbt - 0.5 * expbt * expbt - 1.5) / this.b());
        double value = 2.0 * this.rho() * cx * cy * (t + (expat - 1.0) / this.a() + (expbt - 1.0) / this.b() - (expat * expbt - 1.0) / (this.a() + this.b()));
        return valuex + valuey + value;
    }

    private double a() {
        return this.a_.get(0.0);
    }

    private double sigma() {
        return this.sigma_.get(0.0);
    }

    private double b() {
        return this.b_.get(0.0);
    }

    private double eta() {
        return this.eta_.get(0.0);
    }

    private double rho() {
        return this.rho_.get(0.0);
    }

    private double sigmaP(double t, double s) {
        double temp = 1.0 - Math.exp(-(this.a() + this.b()) * t);
        double temp1 = 1.0 - Math.exp(-this.a() * (s - t));
        double temp2 = 1.0 - Math.exp(-this.b() * (s - t));
        double a3 = this.a() * this.a() * this.a();
        double b3 = this.b() * this.b() * this.b();
        double sigma2 = this.sigma() * this.sigma();
        double eta2 = this.eta() * this.eta();
        double value = 0.5 * sigma2 * temp1 * temp1 * (1.0 - Math.exp(-2.0 * this.a() * t)) / a3 + 0.5 * eta2 * temp2 * temp2 * (1.0 - Math.exp(-2.0 * this.b() * t)) / b3 + 2.0 * this.rho() * this.sigma() * this.eta() / (this.a() * this.b() * (this.a() + this.b())) * temp1 * temp2 * temp;
        return Math.sqrt(value);
    }

    @Override
    public Handle<YieldTermStructure> termStructure() {
        return this.termStructureConsistentModelClass.termStructure();
    }

    @Override
    public double discountBond(double now, double maturity, Array factors) {
        throw new UnsupportedOperationException("not sure whether this is a quantlib error - looks like they forgot to overwrite a virtual method");
    }

    static class FittingParameter
    extends TermStructureFittingParameter {
        public FittingParameter(Handle<YieldTermStructure> termStructure, double a, double sigma, double b, double eta, double rho) {
            super(new Impl(termStructure, a, sigma, b, eta, rho));
        }

        private static class Impl
        implements Parameter.Impl {
            private final Handle<YieldTermStructure> termStructure_;
            double a_;
            double sigma_;
            double b_;
            double eta_;
            double rho_;

            public Impl(Handle<YieldTermStructure> termStructure, double a, double sigma, double b, double eta, double rho) {
                this.termStructure_ = termStructure;
                this.a_ = a;
                this.sigma_ = sigma;
                this.b_ = b;
                this.eta_ = eta;
                this.rho_ = rho;
            }

            @Override
            public double value(Array a, double t) {
                double forward = this.termStructure_.currentLink().forwardRate(t, t, Compounding.Continuous, Frequency.NoFrequency).rate();
                double temp1 = this.sigma_ * (1.0 - Math.exp(-this.a_ * t)) / this.a_;
                double temp2 = this.eta_ * (1.0 - Math.exp(-this.b_ * t)) / this.b_;
                double value = 0.5 * temp1 * temp1 + 0.5 * temp2 * temp2 + this.rho_ * temp1 * temp2 + forward;
                return value;
            }
        }
    }

    private class SwaptionPricingFunction {
        double a_;
        double sigma_;
        double b_;
        double eta_;
        double rho_;
        double w_;
        double T_;
        List<Double> t_;
        double rate_;
        int size_;
        Array A_;
        Array Ba_;
        Array Bb_;
        double mux_;
        double muy_;
        double sigmax_;
        double sigmay_;
        double rhoxy_;

        public SwaptionPricingFunction(double a, double sigma, double b, double eta, double rho, double w, double start, ArrayList<Double> payTimes, double fixedRate, G2 model) {
            this.a_ = a;
            this.sigma_ = sigma;
            this.b_ = b;
            this.eta_ = eta;
            this.rho_ = rho;
            this.w_ = w;
            this.T_ = start;
            this.t_ = payTimes;
            this.rate_ = fixedRate;
            this.size_ = this.t_.size();
            this.A_ = new Array(this.size_);
            this.Ba_ = new Array(this.size_);
            this.Bb_ = new Array(this.size_);
            this.sigmax_ = this.sigma_ * Math.sqrt(0.5 * (1.0 - Math.exp(-2.0 * this.a_ * this.T_)) / this.a_);
            this.sigmay_ = this.eta_ * Math.sqrt(0.5 * (1.0 - Math.exp(-2.0 * this.b_ * this.T_)) / this.b_);
            this.rhoxy_ = this.rho_ * this.eta_ * this.sigma_ * (1.0 - Math.exp(-(this.a_ + this.b_) * this.T_)) / ((this.a_ + this.b_) * this.sigmax_ * this.sigmay_);
            double temp = this.sigma_ * this.sigma_ / (this.a_ * this.a_);
            this.mux_ = -((temp + this.rho_ * this.sigma_ * this.eta_ / (this.a_ * this.b_)) * (1.0 - Math.exp(-a * this.T_)) - 0.5 * temp * (1.0 - Math.exp(-2.0 * this.a_ * this.T_)) - this.rho_ * this.sigma_ * this.eta_ / (this.b_ * (this.a_ + this.b_)) * (1.0 - Math.exp(-(this.b_ + this.a_) * this.T_)));
            temp = this.eta_ * this.eta_ / (this.b_ * this.b_);
            this.muy_ = -((temp + this.rho_ * this.sigma_ * this.eta_ / (this.a_ * this.b_)) * (1.0 - Math.exp(-b * this.T_)) - 0.5 * temp * (1.0 - Math.exp(-2.0 * this.b_ * this.T_)) - this.rho_ * this.sigma_ * this.eta_ / (this.a_ * (this.a_ + this.b_)) * (1.0 - Math.exp(-(this.b_ + this.a_) * this.T_)));
            for (int i = 0; i < this.size_; ++i) {
                this.A_.set(i, model.A(this.T_, this.t_.get(i)));
                this.Ba_.set(i, model.B(this.a_, this.t_.get(i) - this.T_));
                this.Bb_.set(i, model.B(this.b_, this.t_.get(i) - this.T_));
            }
        }

        double mux() {
            return this.mux_;
        }

        double sigmax() {
            return this.sigmax_;
        }

        double getOperatorEq(double x) {
            int i;
            CumulativeNormalDistribution phi = new CumulativeNormalDistribution();
            double temp = (x - this.mux_) / this.sigmax_;
            double txy = Math.sqrt(1.0 - this.rhoxy_ * this.rhoxy_);
            Array lambda = new Array(this.size_);
            for (i = 0; i < this.size_; ++i) {
                double tau = i == 0 ? this.t_.get(0) - this.T_ : this.t_.get(i) - this.t_.get(i - 1);
                double c = i == this.size_ - 1 ? 1.0 + this.rate_ * tau : this.rate_ * tau;
                lambda.set(i, c * this.A_.get(i) * Math.exp(-this.Ba_.get(i) * x));
            }
            SolvingFunction function = new SolvingFunction(lambda, this.Bb_);
            Brent s1d = new Brent();
            s1d.setMaxEvaluations(1000);
            double yb = s1d.solve(function, 1.0E-6, 0.0, -100.0, 100.0);
            double h1 = (yb - this.muy_) / (this.sigmay_ * txy) - this.rhoxy_ * (x - this.mux_) / (this.sigmax_ * txy);
            double value = phi.op(-this.w_ * h1);
            for (i = 0; i < this.size_; ++i) {
                double h2 = h1 + this.Bb_.get(i) * this.sigmay_ * Math.sqrt(1.0 - this.rhoxy_ * this.rhoxy_);
                double kappa = -this.Bb_.get(i) * (this.muy_ - 0.5 * txy * txy * this.sigmay_ * this.sigmay_ * this.Bb_.get(i) + this.rhoxy_ * this.sigmay_ * (x - this.mux_) / this.sigmax_);
                value -= lambda.get(i) * Math.exp(kappa) * phi.op(-this.w_ * h2);
            }
            return Math.exp(-0.5 * temp * temp) * value / (this.sigmax_ * Math.sqrt(Math.PI * 2));
        }

        private class SolvingFunction
        implements Ops.DoubleOp {
            private final Array lambda_;
            private final Array Bb_;

            public SolvingFunction(Array lambda, Array Bb) {
                this.lambda_ = lambda;
                this.Bb_ = Bb;
            }

            @Override
            public double op(double y) {
                double value = 1.0;
                for (int i = 0; i < this.lambda_.size(); ++i) {
                    value -= this.lambda_.get(i) * Math.exp(-this.Bb_.get(i) * y);
                }
                return value;
            }
        }
    }

    private class Dynamics
    extends TwoFactorModel.ShortRateDynamics {
        private final Parameter fitting_;

        public Dynamics(Parameter fitting, double a, double sigma, double b, double eta, double rho) {
            super(G2.this, new OrnsteinUhlenbeckProcess(a, sigma, 0.0, 0.0), new OrnsteinUhlenbeckProcess(b, eta, 0.0, 0.0), rho);
            this.fitting_ = fitting;
        }

        @Override
        public double shortRate(double t, double x, double y) {
            return this.fitting_.get(t) + x + y;
        }
    }
}

