/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model.shortrate.onefactormodels;

import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.model.AffineModel;
import org.jquantlib.model.shortrate.onefactormodels.OneFactorModel;

public abstract class OneFactorAffineModel
extends OneFactorModel
implements AffineModel {
    public OneFactorAffineModel(int nArguments) {
        super(nArguments);
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
    }

    public double discountBond(double now, double maturity, double rate) {
        return this.A(now, maturity) * Math.exp(-this.B(now, maturity) * rate);
    }

    protected abstract double A(double var1, double var3);

    protected abstract double B(double var1, double var3);

    @Override
    public double discountBond(double now, double maturity, Array factors) {
        return this.discountBond(now, maturity, factors.first());
    }

    @Override
    public double discount(double t) {
        double x0 = this.dynamics().process().x0();
        double r0 = this.dynamics().shortRate(0.0, x0);
        return this.discountBond(0.0, t, r0);
    }
}

