/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model.shortrate.onefactormodels;

import org.jquantlib.QL;
import org.jquantlib.instruments.Option;
import org.jquantlib.math.Constants;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.methods.lattices.Lattice;
import org.jquantlib.methods.lattices.TrinomialTree;
import org.jquantlib.model.NullParameter;
import org.jquantlib.model.Parameter;
import org.jquantlib.model.TermStructureFittingParameter;
import org.jquantlib.model.shortrate.onefactormodels.OneFactorModel;
import org.jquantlib.model.shortrate.onefactormodels.TermStructureConsistentModel;
import org.jquantlib.model.shortrate.onefactormodels.TermStructureConsistentModelClass;
import org.jquantlib.model.shortrate.onefactormodels.Vasicek;
import org.jquantlib.pricingengines.BlackFormula;
import org.jquantlib.processes.OrnsteinUhlenbeckProcess;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.TimeGrid;

public class HullWhite
extends Vasicek
implements TermStructureConsistentModel {
    private final TermStructureConsistentModelClass termStructureConsistentModelClass;
    private Parameter phi_;

    public HullWhite(Handle<YieldTermStructure> termStructure) {
        this(termStructure, 0.1, 0.01);
    }

    public HullWhite(Handle<YieldTermStructure> termStructure, double a) {
        this(termStructure, a, 0.01);
    }

    public HullWhite(Handle<YieldTermStructure> termStructure, double a, double sigma) {
        super(termStructure.currentLink().forwardRate(0.0, 0.0, Compounding.Continuous, Frequency.NoFrequency).rate(), a, 0.0, sigma, 0.0);
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.termStructureConsistentModelClass = new TermStructureConsistentModelClass(termStructure);
        this.b_ = new NullParameter();
        this.lambda_ = new NullParameter();
        this.generateArguments();
        this.termStructureConsistentModelClass.termStructure().addObserver(this);
    }

    @Override
    protected void generateArguments() {
        this.phi_ = new FittingParameter(this.termStructureConsistentModelClass.termStructure(), this.a(), this.sigma());
    }

    @Override
    public double discountBondOption(Option.Type type, double strike, double maturity, double bondMaturity) {
        double _a = this.a();
        double v = _a < Math.sqrt(Constants.QL_EPSILON) ? this.sigma() * this.B(maturity, bondMaturity) * Math.sqrt(maturity) : this.sigma() * this.B(maturity, bondMaturity) * Math.sqrt(0.5 * (1.0 - Math.exp(-2.0 * _a * maturity)) / _a);
        double f = this.termStructureConsistentModelClass.termStructure().currentLink().discount(bondMaturity);
        double k = this.termStructureConsistentModelClass.termStructure().currentLink().discount(maturity) * strike;
        return BlackFormula.blackFormula(type, k, f, v);
    }

    public double convexityBias(double futurePrice, double t, double T, double sigma, double a) {
        QL.require(futurePrice >= 0.0, "negative futures price not allowed");
        QL.require(t >= 0.0, "negative t not allowed");
        QL.require(T >= t, "T must not be less than t");
        QL.require(a >= 0.0, "negative a not allowed");
        double deltaT = T - t;
        double tempDeltaT = (1.0 - Math.exp(-a * deltaT)) / a;
        double halfSigmaSquare = sigma * sigma / 2.0;
        double lambda = halfSigmaSquare * (1.0 - Math.exp(-2.0 * a * t)) / a * tempDeltaT * tempDeltaT;
        double tempT = (1.0 - Math.exp(-a * t)) / a;
        double phi = halfSigmaSquare * tempDeltaT * tempT * tempT;
        double z = lambda + phi;
        double futureRate = (100.0 - futurePrice) / 100.0;
        return (1.0 - Math.exp(-z)) * (futureRate + 1.0 / (T - t));
    }

    @Override
    public Lattice tree(TimeGrid grid) {
        TermStructureFittingParameter phi = new TermStructureFittingParameter(this.termStructureConsistentModelClass.termStructure());
        Dynamics numericDynamics = new Dynamics(phi, this.a(), this.sigma());
        TrinomialTree trinomial = new TrinomialTree(numericDynamics.process(), grid, true);
        OneFactorModel.ShortRateTree numericTree = new OneFactorModel.ShortRateTree(this, trinomial, numericDynamics, grid);
        TermStructureFittingParameter.NumericalImpl impl = (TermStructureFittingParameter.NumericalImpl)phi.implementation();
        impl.reset();
        for (int i = 0; i < grid.size() - 1; ++i) {
            double discountBond = this.termStructureConsistentModelClass.termStructure().currentLink().discount(grid.at(i + 1));
            Array statePrices = numericTree.statePrices(i);
            int size = numericTree.size(i);
            double dt = numericTree.timeGrid().dt(i);
            double dx = trinomial.dx(i);
            double x = trinomial.underlying(i, 0);
            double value = 0.0;
            for (int j = 0; j < size; ++j) {
                value += statePrices.get(j) * Math.exp(-x * dt);
                x += dx;
            }
            value = Math.log(value / discountBond) / dt;
            impl.set(grid.index(i), value);
        }
        return numericTree;
    }

    @Override
    protected double A(double t, double T) {
        double discount1 = this.termStructureConsistentModelClass.termStructure().currentLink().discount(t);
        double discount2 = this.termStructureConsistentModelClass.termStructure().currentLink().discount(T);
        double forward = this.termStructureConsistentModelClass.termStructure().currentLink().forwardRate(t, t, Compounding.Continuous, Frequency.NoFrequency).rate();
        double temp = this.sigma() * this.B(t, T);
        double value = this.B(t, T) * forward - 0.25 * temp * temp * this.B(0.0, 2.0 * t);
        return Math.exp(value) * discount2 / discount1;
    }

    @Override
    public OneFactorModel.ShortRateDynamics dynamics() {
        return new Dynamics(this.phi_, this.a(), this.sigma());
    }

    @Override
    public Handle<YieldTermStructure> termStructure() {
        return this.termStructureConsistentModelClass.termStructure();
    }

    public class Dynamics
    extends OneFactorModel.ShortRateDynamics {
        private final Parameter fitting_;

        public Dynamics(Parameter fitting, double a, double sigma) {
            super(HullWhite.this, new OrnsteinUhlenbeckProcess(a, sigma, 0.0, 0.0));
            this.fitting_ = fitting;
        }

        @Override
        public double variable(double t, double r) {
            return r - this.fitting_.get(t);
        }

        @Override
        public double shortRate(double t, double x) {
            return x + this.fitting_.get(t);
        }
    }

    private static class FittingParameter
    extends TermStructureFittingParameter {
        public FittingParameter(Handle<YieldTermStructure> termStructure, double a, double sigma) {
            super(new Impl(termStructure, a, sigma));
        }

        private static class Impl
        implements Parameter.Impl {
            private final Handle<YieldTermStructure> termStructure;
            private final double a;
            private final double sigma;

            public Impl(Handle<YieldTermStructure> termStructure, double a, double sigma) {
                this.termStructure = termStructure;
                this.a = a;
                this.sigma = sigma;
            }

            @Override
            public double value(Array params, double t) {
                double forwardRate = this.termStructure.currentLink().forwardRate(t, t, Compounding.Continuous, Frequency.NoFrequency).rate();
                double temp = this.sigma * (1.0 - Math.exp(-this.a * t)) / this.a;
                return forwardRate + 0.5 * temp * temp;
            }
        }
    }
}

