/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model.shortrate.onefactormodels;

import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.Ops;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.optimization.PositiveConstraint;
import org.jquantlib.math.solvers1D.Brent;
import org.jquantlib.methods.lattices.Lattice;
import org.jquantlib.methods.lattices.TrinomialTree;
import org.jquantlib.model.ConstantParameter;
import org.jquantlib.model.Parameter;
import org.jquantlib.model.TermStructureFittingParameter;
import org.jquantlib.model.shortrate.onefactormodels.OneFactorModel;
import org.jquantlib.model.shortrate.onefactormodels.TermStructureConsistentModel;
import org.jquantlib.model.shortrate.onefactormodels.TermStructureConsistentModelClass;
import org.jquantlib.processes.OrnsteinUhlenbeckProcess;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.TimeGrid;

public class BlackKarasinski
extends OneFactorModel
implements TermStructureConsistentModel {
    private final TermStructureConsistentModelClass termstructureConsistentModel;
    private static final String no_defined_process_for_bk = "no defined process for Black-Karasinski";
    private Parameter a_;
    private Parameter sigma_;

    public BlackKarasinski(Handle<YieldTermStructure> termStructure) {
        this(termStructure, 0.1, 0.1);
    }

    public BlackKarasinski(Handle<YieldTermStructure> termStructure, double a, double sigma) {
        super(2);
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.termstructureConsistentModel = new TermStructureConsistentModelClass(termStructure);
        this.a_ = (Parameter)this.arguments_.get(0);
        this.sigma_ = (Parameter)this.arguments_.get(1);
        this.a_ = new ConstantParameter(a, new PositiveConstraint());
        this.sigma_ = new ConstantParameter(sigma, new PositiveConstraint());
        termStructure.addObserver(this);
    }

    public double a() {
        return this.a_.get(0.0);
    }

    public double sigma() {
        return this.sigma_.get(0.0);
    }

    @Override
    public OneFactorModel.ShortRateDynamics dynamics() {
        throw new LibraryException(no_defined_process_for_bk);
    }

    @Override
    public Lattice tree(TimeGrid grid) {
        TermStructureFittingParameter phi = new TermStructureFittingParameter(this.termstructureConsistentModel.termStructure());
        Dynamics numericDynamics = new Dynamics(phi, this.a(), this.sigma());
        TrinomialTree trinomial = new TrinomialTree(numericDynamics.process(), grid, true);
        OneFactorModel.ShortRateTree numericTree = null;
        TermStructureFittingParameter.NumericalImpl impl = (TermStructureFittingParameter.NumericalImpl)phi.implementation();
        impl.reset();
        double value = 1.0;
        double vMin = -50.0;
        double vMax = 50.0;
        for (int i = 0; i < grid.size() - 1; ++i) {
            double discountBond = this.termstructureConsistentModel.termStructure().currentLink().discount(grid.at(i + 1));
            double xMin = trinomial.underlying(i, 0);
            double dx = trinomial.dx(i);
            Helper finder = new Helper(i, xMin, dx, discountBond, numericTree);
            Brent s1d = new Brent();
            s1d.setMaxEvaluations(1000);
            value = s1d.solve(finder, 1.0E-7, value, -50.0, 50.0);
            impl.set(grid.index(i), value);
        }
        return numericTree;
    }

    @Override
    public Handle<YieldTermStructure> termStructure() {
        return this.termstructureConsistentModel.termStructure();
    }

    private class Dynamics
    extends OneFactorModel.ShortRateDynamics {
        private final Parameter fitting_;

        public Dynamics(Parameter fitting, double alpha, double sigma) {
            super(BlackKarasinski.this, new OrnsteinUhlenbeckProcess(alpha, sigma, 0.0, 0.0));
            this.fitting_ = fitting;
        }

        @Override
        public double variable(double t, double r) {
            return Math.log(r) - this.fitting_.get(t);
        }

        @Override
        public double shortRate(double t, double x) {
            return Math.exp(x + this.fitting_.get(t));
        }
    }

    private class Helper
    implements Ops.DoubleOp {
        private final int size_;
        private final double dt_;
        private final double xMin_;
        private final double dx_;
        private final Array statePrices_;
        private final double discountBondPrice_;

        public Helper(int i, double xMin, double dx, double discountBondPrice, OneFactorModel.ShortRateTree tree) {
            this.size_ = tree.size(i);
            this.dt_ = tree.timeGrid().dt(i);
            this.xMin_ = xMin;
            this.dx_ = dx;
            this.statePrices_ = tree.statePrices(i);
            this.discountBondPrice_ = discountBondPrice;
        }

        @Override
        public double op(double theta) {
            double value = this.discountBondPrice_;
            double x = this.xMin_;
            for (int j = 0; j < this.size_; ++j) {
                double discount = Math.exp(-Math.exp(theta + x) * this.dt_);
                value -= this.statePrices_.get(j) * discount;
                x += this.dx_;
            }
            return value;
        }
    }
}

