/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model.equity;

import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.optimization.Constraint;
import org.jquantlib.math.optimization.PositiveConstraint;
import org.jquantlib.model.CalibratedModel;
import org.jquantlib.model.ConstantParameter;
import org.jquantlib.model.Parameter;
import org.jquantlib.processes.HestonProcess;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.RelinkableHandle;
import org.jquantlib.quotes.SimpleQuote;

public class HestonModel
extends CalibratedModel {
    protected RelinkableHandle<Quote> v0_;
    protected RelinkableHandle<Quote> kappa_;
    protected RelinkableHandle<Quote> theta_;
    protected RelinkableHandle<Quote> sigma_;
    protected RelinkableHandle<Quote> rho_;

    public HestonModel(HestonProcess process) {
        super(5);
        this.v0_ = process.v0();
        this.kappa_ = process.kappa();
        this.theta_ = process.theta();
        this.sigma_ = process.sigma();
        this.rho_ = process.rho();
        this.arguments_.set(0, new ConstantParameter(((Quote)process.theta().currentLink()).value(), new PositiveConstraint()));
        this.arguments_.set(1, new ConstantParameter(((Quote)process.kappa().currentLink()).value(), new PositiveConstraint()));
        this.arguments_.set(2, new ConstantParameter(((Quote)process.sigma().currentLink()).value(), new PositiveConstraint()));
        this.arguments_.set(3, new ConstantParameter(((Quote)process.rho().currentLink()).value(), new PositiveConstraint()));
        this.arguments_.set(4, new ConstantParameter(((Quote)process.v0().currentLink()).value(), new PositiveConstraint()));
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
    }

    @Override
    public void generateArguments() {
        this.v0_.linkTo(new SimpleQuote((SimpleQuote)this.v0_.currentLink()));
        this.kappa_.linkTo(new SimpleQuote((SimpleQuote)this.kappa_.currentLink()));
        this.theta_.linkTo(new SimpleQuote((SimpleQuote)this.theta_.currentLink()));
        this.sigma_.linkTo(new SimpleQuote((SimpleQuote)this.sigma_.currentLink()));
        this.rho_.linkTo(new SimpleQuote((SimpleQuote)this.rho_.currentLink()));
    }

    public double theta() {
        return ((Parameter)this.arguments_.get(0)).get(0.0);
    }

    public double kappa() {
        return ((Parameter)this.arguments_.get(1)).get(0.0);
    }

    public double sigma() {
        return ((Parameter)this.arguments_.get(2)).get(0.0);
    }

    public double rho() {
        return ((Parameter)this.arguments_.get(3)).get(0.0);
    }

    public double v0() {
        return ((Parameter)this.arguments_.get(4)).get(0.0);
    }

    private class VolatilityConstraint
    extends Constraint {
        public VolatilityConstraint() {
            throw new UnsupportedOperationException("Work in progress. Todo: check class hierarchy");
        }

        @Override
        public boolean test(Array p) {
            double theta = p.get(0);
            double kappa = p.get(1);
            double sigma = p.get(2);
            return sigma >= 0.0 && sigma * sigma < 2.0 * kappa * theta;
        }
    }
}

