/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.optimization.Constraint;
import org.jquantlib.math.optimization.NoConstraint;

@QualityAssurance(quality=QualityAssurance.Quality.Q1_TRANSLATION, version=QualityAssurance.Version.V097, reviewers={"Richard Gomes"})
public class Parameter {
    protected Constraint constraint;
    protected Array params;
    protected Impl impl;

    public Parameter() {
        this.constraint = new NoConstraint();
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
    }

    protected Parameter(int size, Impl impl, Constraint constraint) {
        this.constraint = constraint;
        this.impl = impl;
        this.params = new Array(size);
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
    }

    public final Array params() {
        return this.params;
    }

    public void setParam(int i, double x) {
        this.params.set(i, x);
    }

    public boolean testParams(Array params) {
        return this.constraint.test(params);
    }

    public double get(double t) {
        return this.impl.value(this.params, t);
    }

    public int size() {
        return this.params.size();
    }

    public final Impl implementation() {
        return this.impl;
    }

    protected static interface Impl {
        public double value(Array var1, double var2);
    }
}

