/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.optimization;

import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.optimization.EndCriteria;
import org.jquantlib.math.optimization.OptimizationMethod;
import org.jquantlib.math.optimization.Problem;

public class LevenbergMarquardt
extends OptimizationMethod {
    private final double epsfcn_;
    private final double xtol_;
    private final double gtol_;
    private Integer info_;

    public LevenbergMarquardt() {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.epsfcn_ = 1.0E-8;
        this.xtol_ = 1.0E-8;
        this.gtol_ = 1.0E-8;
    }

    public LevenbergMarquardt(double epsfcn, double xtol, double gtol) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.epsfcn_ = epsfcn;
        this.xtol_ = xtol;
        this.gtol_ = gtol;
    }

    @Override
    public EndCriteria.Type minimize(Problem P, EndCriteria endCriteria) {
        EndCriteria.Type ecType = EndCriteria.Type.None;
        P.reset();
        Array x_ = P.currentValue();
        ProblemData.getProblemData().setProblem(P);
        ProblemData.getProblemData().setInitCostValues(P.costFunction().values(x_));
        int m = ProblemData.getProblemData().initCostValues_.size();
        int n = x_.size();
        Array xx = new Array(0);
        xx.addAssign(x_);
        boolean mode = true;
        double factor = 1.0;
        boolean nprint = false;
        boolean info = false;
        boolean nfev = false;
        Array fjac = new Array(0);
        int ldfjac = m;
        return ecType;
    }

    public void fcn(int x1, int n, double x2, double fvec, int x3) {
    }

    private static class ProblemData {
        static ProblemData p = null;
        private Problem thisP_;
        private Array initCostValues_;

        private ProblemData() {
        }

        public static ProblemData getProblemData() {
            if (p == null) {
                p = new ProblemData();
            }
            return p;
        }

        public Problem problem() {
            return this.thisP_;
        }

        public Array initCostValues() {
            return this.initCostValues_;
        }

        public void setProblem(Problem problem) {
            this.thisP_ = problem;
        }

        public void setInitCostValues(Array initCostValues) {
            this.initCostValues_ = initCostValues;
        }
    }
}

