/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.optimization;

import org.jquantlib.QL;

public class EndCriteria {
    protected final int maxIterations_;
    protected final int maxStationaryStateIterations_;
    protected final double rootEpsilon_;
    protected final double functionEpsilon_;
    protected final double gradientNormEpsilon_;
    private Type ecType;
    private int statStateIterations;

    public EndCriteria(int maxIterations, int maxStationaryStateIterations, double rootEpsilon, double functionEpsilon, double gradientNormEpsilon) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.maxIterations_ = maxIterations;
        this.rootEpsilon_ = rootEpsilon;
        this.functionEpsilon_ = functionEpsilon;
        this.maxStationaryStateIterations_ = maxStationaryStateIterations != 0 ? maxStationaryStateIterations : Math.min(maxIterations / 2, 100);
        this.gradientNormEpsilon_ = Double.isNaN(gradientNormEpsilon) ? this.functionEpsilon_ : gradientNormEpsilon;
        QL.require(this.maxStationaryStateIterations_ >= 1, "maxStationaryStateIterations must be greater than one");
        QL.require(this.maxStationaryStateIterations_ <= this.maxIterations_, "maxStationaryStateIterations_ must be less than maxIterations_");
    }

    public boolean checkMaxIterations(int iteration, Type ecType) {
        if (iteration < this.maxIterations_) {
            return false;
        }
        this.ecType = Type.MaxIterations;
        throw new UnsupportedOperationException("work in progress");
    }

    public boolean checkStationaryPoint(double xOld, double xNew, int statStateIterations, Type ecType) {
        if (Math.abs(xNew - xOld) >= this.rootEpsilon_) {
            this.statStateIterations = 0;
            return false;
        }
        ++this.statStateIterations;
        if (statStateIterations <= this.maxStationaryStateIterations_) {
            return false;
        }
        this.ecType = Type.StationaryPoint;
        return true;
    }

    public boolean checkStationaryFunctionValue(double fxOld, double fxNew, int statStateIterations, Type ecType) {
        if (Math.abs(fxNew - fxOld) >= this.functionEpsilon_) {
            this.statStateIterations = 0;
            return false;
        }
        ++this.statStateIterations;
        if (statStateIterations <= this.maxStationaryStateIterations_) {
            return false;
        }
        this.ecType = Type.StationaryFunctionValue;
        return true;
    }

    public boolean checkStationaryFunctionAccuracy(double f, boolean positiveOptimization, Type ecType) {
        if (!positiveOptimization) {
            return false;
        }
        if (f >= this.functionEpsilon_) {
            return false;
        }
        this.ecType = Type.StationaryFunctionAccuracy;
        return true;
    }

    public boolean checkZeroGradientNorm(double gradientNorm, Type ecType) {
        if (gradientNorm >= this.gradientNormEpsilon_) {
            return false;
        }
        this.ecType = Type.ZeroGradientNorm;
        return true;
    }

    public boolean get(int iteration, int statStateIterations, boolean positiveOptimization, double fold, double normgold, double fnew, double normgnew, Type ecType) {
        return this.checkMaxIterations(iteration, ecType) || this.checkStationaryFunctionValue(fold, fnew, statStateIterations, ecType) || this.checkStationaryFunctionAccuracy(fnew, positiveOptimization, ecType) || this.checkZeroGradientNorm(normgnew, ecType);
    }

    public final int getMaxIterations() {
        return this.maxIterations_;
    }

    public final int getMaxStationaryStateIterations() {
        return this.maxStationaryStateIterations_;
    }

    public final double getRootEpsilon() {
        return this.rootEpsilon_;
    }

    public final double getFunctionEpsilon() {
        return this.functionEpsilon_;
    }

    public final double getGradientNormEpsilon() {
        return this.gradientNormEpsilon_;
    }

    public static enum Type {
        None,
        MaxIterations,
        StationaryPoint,
        StationaryFunctionValue,
        StationaryFunctionAccuracy,
        ZeroGradientNorm,
        Unknown;

    }
}

