/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.matrixutilities.internal;

import java.util.EnumSet;
import java.util.Set;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.matrixutilities.internal.Address;
import org.jquantlib.math.matrixutilities.internal.DirectAddress;

public class DirectMatrixAddress
extends DirectAddress
implements Address.MatrixAddress {
    public DirectMatrixAddress(double[] data, int row0, int row1, Address chain, int col0, int col1, Set<Address.Flags> flags, boolean contiguous, int rows, int cols) {
        super(data, row0, row1, chain, col0, col1, flags, contiguous, rows, cols);
    }

    @Override
    public Address.MatrixAddress toFortran() {
        return this.isFortran() ? this : new DirectMatrixAddress(this.data, this.row0, this.row1, this.chain, this.col0, this.col1, EnumSet.of(Address.Flags.FORTRAN), this.contiguous, this.rows, this.cols);
    }

    @Override
    public Address.MatrixAddress toJava() {
        return this.isFortran() ? new DirectMatrixAddress(this.data, this.row0 + 1, this.row1 + 1, this.chain, this.col0 + 1, this.col1 + 1, EnumSet.noneOf(Address.Flags.class), this.contiguous, this.rows, this.cols) : this;
    }

    @Override
    public Address.MatrixAddress.MatrixOffset offset() {
        return new DirectMatrixAddressOffset(this.offset, this.offset);
    }

    @Override
    public Address.MatrixAddress.MatrixOffset offset(int row, int col) {
        return new DirectMatrixAddressOffset(row, col);
    }

    @Override
    public int op(int row, int col) {
        return (this.row0 + row) * this.cols + (this.col0 + col);
    }

    @Override
    public DirectMatrixAddress clone() {
        try {
            return (DirectMatrixAddress)super.clone();
        }
        catch (Exception e) {
            throw new LibraryException(e);
        }
    }

    private class DirectMatrixAddressOffset
    extends DirectAddress.DirectAddressOffset
    implements Address.MatrixAddress.MatrixOffset {
        public DirectMatrixAddressOffset(int row, int col) {
            this.row = DirectMatrixAddress.this.row0 + row;
            this.col = DirectMatrixAddress.this.col0 + col;
        }

        @Override
        public void nextRow() {
            ++this.row;
        }

        @Override
        public void nextCol() {
            ++this.col;
        }

        @Override
        public void prevRow() {
            --this.row;
        }

        @Override
        public void prevCol() {
            --this.col;
        }

        @Override
        public void setRow(int row) {
            this.row = DirectMatrixAddress.this.row0 + row;
        }

        @Override
        public void setCol(int col) {
            this.col = DirectMatrixAddress.this.col0 + col;
        }

        @Override
        public int op() {
            return this.row * DirectMatrixAddress.this.cols + this.col;
        }
    }
}

