/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.matrixutilities;

import java.util.Arrays;
import org.jquantlib.QL;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.matrixutilities.Matrix;
import org.jquantlib.math.matrixutilities.internal.Address;
import org.jquantlib.math.optimization.Minpack;

public class QRDecomposition {
    private final int m;
    private final int n;
    private final Matrix A;
    private final Matrix Q;
    private final Matrix R;
    private final Matrix P;
    private final int[] ipvt;
    private final boolean isNonSingular;

    public QRDecomposition(Matrix matrix) {
        this(matrix, false);
    }

    public QRDecomposition(Matrix A, boolean pivot) {
        int i;
        this.A = A;
        this.m = A.rows();
        this.n = A.cols();
        this.ipvt = new int[this.n];
        Matrix mT = A.clone().toJava().transpose();
        Array rdiag = new Array(this.n);
        Array wa = new Array(this.n);
        System.out.println("mT (BEFORE) = " + mT);
        Minpack.qrfac(this.m, this.n, mT, pivot, this.ipvt, rdiag, rdiag, wa);
        System.out.println("mT (AFTER)  = " + mT);
        System.out.println("Array ipvt = " + Arrays.toString(this.ipvt));
        System.out.println("Array rdiag = " + rdiag);
        System.out.println("Array wa = " + wa);
        double[][] r = new double[this.n][this.n];
        for (int i2 = 0; i2 < this.n; ++i2) {
            r[i2][i2] = rdiag.get(i2);
            if (i2 >= this.m) continue;
            for (int k = i2 + 1; k < this.n; ++k) {
                r[i2][k] = mT.get(k, i2);
            }
        }
        double[][] q = new double[this.m][this.n];
        double[] w = new double[this.m];
        for (int k = 0; k < this.m; ++k) {
            Arrays.fill(w, 0.0);
            w[k] = 1.0;
            for (int j = 0; j < Math.min(this.n, this.m); ++j) {
                double t3 = mT.get(j, j);
                if (t3 != 0.0) {
                    double t = 0.0;
                    for (int p = j; p < this.m; ++p) {
                        t += mT.get(j, p) * w[p];
                    }
                    t /= t3;
                    for (int i3 = j; i3 < this.m; ++i3) {
                        int n = i3;
                        w[n] = w[n] - mT.get(j, i3) * t;
                    }
                }
                q[k][j] = w[j];
            }
        }
        double[][] p = new double[this.n][this.n];
        if (pivot) {
            for (i = 0; i < this.n; ++i) {
                p[this.ipvt[i]][i] = 1.0;
            }
        } else {
            for (i = 0; i < this.n; ++i) {
                p[i][i] = 1.0;
            }
        }
        this.isNonSingular = this.isNonSingular(rdiag.$);
        boolean fortran = ((Address.MatrixAddress)this.A.addr).isFortran();
        this.R = fortran ? new Matrix(r).toFortran() : new Matrix(r);
        this.Q = fortran ? new Matrix(q).toFortran() : new Matrix(q);
        this.P = fortran ? new Matrix(p).toFortran() : new Matrix(p);
        System.out.println("Matrix Q = " + this.Q.toString());
        System.out.println("Matrix R = " + this.R.toString());
        System.out.println("Matrix P = " + this.P.toString());
        System.out.println("Matrix mT = " + mT.toString());
    }

    public Matrix Q() {
        return this.Q;
    }

    public Matrix R() {
        return this.R;
    }

    public Matrix P() {
        return this.P;
    }

    public boolean isNonSingular() {
        return this.isNonSingular;
    }

    public Array solve(Array b, boolean pivot, Array d) {
        QL.require(b.size() == this.m, "dimensions of A and b don't match");
        QL.require(d != null && !d.empty() && d.size() == this.n, "dimensions of A and d don't match");
        Matrix aT = this.A.transpose();
        Matrix rT = this.R.transpose();
        Array sdiag = new Array(this.n);
        Array wa = new Array(this.n);
        Array ld = new Array(this.n);
        if (d != null && !d.empty()) {
            ld.fill(d);
        }
        Array x = new Array(this.n);
        Array qtb = this.Q.transpose().mul(b);
        throw new UnsupportedOperationException();
    }

    private boolean isNonSingular(double[] rdiag) {
        for (double diag : rdiag) {
            if (diag != 0.0) continue;
            return false;
        }
        return true;
    }
}

