/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.matrixutilities;

import org.jquantlib.QL;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.matrixutilities.Matrix;
import org.jquantlib.math.matrixutilities.internal.Address;

@QualityAssurance(quality=QualityAssurance.Quality.Q1_TRANSLATION, version=QualityAssurance.Version.OTHER, reviewers={"Richard Gomes"})
public class CholeskyDecomposition {
    private static final String MATRIX_IS_NOT_SIMMETRIC_POSITIVE = "Matrix is not symmetric positive definite.";
    private final int n;
    private final Matrix L;
    private boolean isspd;

    public CholeskyDecomposition(Matrix A) {
        QL.require(A.rows() == A.cols(), "matrix must be square");
        this.n = A.rows();
        this.L = new Matrix(this.n, this.n);
        this.isspd = A.rows() == A.cols();
        for (int j = 0; j < this.n; ++j) {
            int k;
            double d = 0.0;
            for (k = 0; k < j; ++k) {
                double s = 0.0;
                for (int i = 0; i < k; ++i) {
                    s += this.L.$[((Address.MatrixAddress)this.L.addr).op(k, i)] * this.L.$[((Address.MatrixAddress)this.L.addr).op(j, i)];
                }
                this.L.$[((Address.MatrixAddress)this.L.addr).op((int)j, (int)k)] = s = (A.$[((Address.MatrixAddress)A.addr).op(j, k)] - s) / this.L.$[((Address.MatrixAddress)this.L.addr).op(k, k)];
                d += s * s;
                this.isspd &= A.$[((Address.MatrixAddress)A.addr).op(k, j)] == A.$[((Address.MatrixAddress)A.addr).op(j, k)];
            }
            d = A.$[((Address.MatrixAddress)A.addr).op(j, j)] - d;
            this.isspd = this.isspd && d > 0.0;
            this.L.$[((Address.MatrixAddress)this.L.addr).op((int)j, (int)j)] = Math.sqrt(Math.max(d, 0.0));
            for (k = j + 1; k < this.n; ++k) {
                this.L.$[((Address.MatrixAddress)this.L.addr).op((int)j, (int)k)] = 0.0;
            }
        }
    }

    public boolean isSPD() {
        return this.isspd;
    }

    public Matrix L() {
        return this.L.clone();
    }

    public Matrix solve(Matrix B) {
        int i;
        int j;
        int k;
        QL.require(B.rows() == this.n, "matrix is incompatible");
        if (!this.isSPD()) {
            throw new LibraryException(MATRIX_IS_NOT_SIMMETRIC_POSITIVE);
        }
        int nx = B.cols();
        Matrix X = B.clone();
        for (k = 0; k < this.n; ++k) {
            for (j = 0; j < nx; ++j) {
                for (i = 0; i < k; ++i) {
                    int n = ((Address.MatrixAddress)X.addr).op(k, j);
                    X.$[n] = X.$[n] - X.$[((Address.MatrixAddress)X.addr).op(i, j)] * this.L.$[((Address.MatrixAddress)this.L.addr).op(k, i)];
                }
                int n = ((Address.MatrixAddress)X.addr).op(k, j);
                X.$[n] = X.$[n] / this.L.$[((Address.MatrixAddress)this.L.addr).op(k, k)];
            }
        }
        for (k = this.n - 1; k >= 0; --k) {
            for (j = 0; j < nx; ++j) {
                for (i = k + 1; i < this.n; ++i) {
                    int n = ((Address.MatrixAddress)X.addr).op(k, j);
                    X.$[n] = X.$[n] - X.$[((Address.MatrixAddress)X.addr).op(i, j)] * this.L.$[((Address.MatrixAddress)this.L.addr).op(i, k)];
                }
                int n = ((Address.MatrixAddress)X.addr).op(k, j);
                X.$[n] = X.$[n] / this.L.$[((Address.MatrixAddress)this.L.addr).op(k, k)];
            }
        }
        return X;
    }
}

