/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.interpolations;

import org.jquantlib.math.interpolations.AbstractInterpolation;
import org.jquantlib.math.matrixutilities.Array;

public class LinearInterpolation
extends AbstractInterpolation {
    public LinearInterpolation(Array vx, Array vy) {
        this.impl = new LinearInterpolationImpl(vx, vy);
        this.impl.update();
    }

    private class LinearInterpolationImpl
    extends AbstractInterpolation.Impl {
        private final Array vp;
        private final Array vs;

        protected LinearInterpolationImpl(Array vx, Array vy) {
            super(vx, vy);
            this.vp = new Array(vx.size());
            this.vs = new Array(vx.size());
        }

        @Override
        public void update() {
            this.vp.set(0, 0.0);
            for (int i = 1; i < this.vx.size(); ++i) {
                double dx = this.vx.get(i) - this.vx.get(i - 1);
                double value = (this.vy.get(i) - this.vy.get(i - 1)) / dx;
                this.vs.set(i - 1, value);
                value = this.vp.get(i - 1) + dx * (this.vy.get(i - 1) + 0.5 * dx * this.vs.get(i - 1));
                this.vp.set(i, value);
            }
        }

        @Override
        public double op(double x) {
            int i = this.locate(x);
            return this.vy.get(i) + (x - this.vx.get(i)) * this.vs.get(i);
        }

        @Override
        public double primitive(double x) {
            int i = this.locate(x);
            double dx = x - this.vx.get(i);
            return this.vp.get(i - 1) + dx * (this.vy.get(i - 1) + 0.5 * dx * this.vs.get(i - 1));
        }

        @Override
        public double derivative(double x) {
            int i = this.locate(x);
            return this.vs.get(i);
        }

        @Override
        public double secondDerivative(double x) {
            return 0.0;
        }
    }
}

