/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.interpolations;

import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.math.Closeness;
import org.jquantlib.math.interpolations.DefaultExtrapolator;
import org.jquantlib.math.interpolations.Interpolation;
import org.jquantlib.math.matrixutilities.Array;

public abstract class AbstractInterpolation
implements Interpolation {
    protected Impl impl;
    private final DefaultExtrapolator delegatedExtrapolator = new DefaultExtrapolator();

    @Override
    public boolean empty() {
        return this.impl == null;
    }

    @Override
    public double op(double x) {
        return this.op(x, false);
    }

    @Override
    public double op(double x, boolean allowExtrapolation) {
        this.checkRange(x, allowExtrapolation);
        return this.impl.op(x);
    }

    @Override
    public double primitive(double x) {
        return this.primitive(x, false);
    }

    @Override
    public double primitive(double x, boolean allowExtrapolation) {
        this.checkRange(x, allowExtrapolation);
        return this.impl.primitive(x);
    }

    @Override
    public double derivative(double x) {
        return this.derivative(x, false);
    }

    @Override
    public double derivative(double x, boolean allowExtrapolation) {
        this.checkRange(x, allowExtrapolation);
        return this.impl.derivative(x);
    }

    @Override
    public double secondDerivative(double x) {
        return this.secondDerivative(x, false);
    }

    @Override
    public double secondDerivative(double x, boolean allowExtrapolation) {
        this.checkRange(x, allowExtrapolation);
        return this.impl.secondDerivative(x);
    }

    @Override
    public double xMin() {
        return this.impl.xMin();
    }

    @Override
    public double xMax() {
        return this.impl.xMax();
    }

    @Override
    public boolean isInRange(double x) {
        return this.impl.isInRange(x);
    }

    @Override
    public void update() {
        this.impl.update();
    }

    protected final void checkRange(double x, boolean extrapolate) {
        if (!(extrapolate || this.allowsExtrapolation() || this.impl.isInRange(x))) {
            StringBuilder sb = new StringBuilder();
            sb.append("interpolation range is [");
            sb.append(this.xMin()).append(", ").append(this.xMax());
            sb.append("]: extrapolation at ");
            sb.append(x);
            sb.append(" not allowed");
            throw new IllegalArgumentException(sb.toString());
        }
    }

    @Override
    public final boolean allowsExtrapolation() {
        return this.delegatedExtrapolator.allowsExtrapolation();
    }

    @Override
    public void disableExtrapolation() {
        this.delegatedExtrapolator.disableExtrapolation();
    }

    @Override
    public void enableExtrapolation() {
        this.delegatedExtrapolator.enableExtrapolation();
    }

    protected class LogInterpolationImpl
    extends Impl {
        private final Array logY_;
        private final Interpolation interpolation_;

        public LogInterpolationImpl(Array vx, Array vy, Interpolation.Interpolator factory) {
            super(vx, vy);
            this.logY_ = new Array(vx.size());
            this.interpolation_ = factory.interpolate(vx, this.logY_);
        }

        @Override
        public void update() {
            for (int i = 0; i < this.logY_.size(); ++i) {
                QL.require(this.vy.get(i) > 0.0, "invalid value");
                this.logY_.set(i, Math.log(this.vy.get(i)));
            }
            this.interpolation_.update();
        }

        @Override
        public double op(double x) {
            return Math.exp(this.interpolation_.op(x, true));
        }

        @Override
        public double primitive(double x) {
            throw new UnsupportedOperationException("LogInterpolation primitive not implemented");
        }

        @Override
        public double derivative(double x) {
            return this.op(x) * this.interpolation_.derivative(x, true);
        }

        @Override
        public double secondDerivative(double x) {
            return this.derivative(x) * this.interpolation_.derivative(x, true) + this.op(x) * this.interpolation_.secondDerivative(x, true);
        }
    }

    protected abstract class Impl {
        protected Array vx;
        protected Array vy;

        protected Impl(Array vx, Array vy) {
            this.vx = vx;
            this.vy = vy;
            QL.require(vx.size() >= 2, "not enough points to interpolate");
            QL.require(this.extraSafetyChecks(), "unsorted values on array X");
        }

        public final double xMin() {
            return this.vx.first();
        }

        public final double xMax() {
            return this.vx.last();
        }

        public final boolean isInRange(double x) {
            QL.require(this.extraSafetyChecks(), "unsorted values on array X");
            double x1 = this.xMin();
            double x2 = this.xMax();
            return x >= x1 && x <= x2 || Closeness.isClose(x, x1) || Closeness.isClose(x, x2);
        }

        public final double op(double x, boolean allowExtrapolation) {
            AbstractInterpolation.this.checkRange(x, allowExtrapolation);
            return this.op(x);
        }

        public final double primitive(double x, boolean allowExtrapolation) {
            AbstractInterpolation.this.checkRange(x, allowExtrapolation);
            return this.primitive(x);
        }

        public final double derivative(double x, boolean allowExtrapolation) {
            AbstractInterpolation.this.checkRange(x, allowExtrapolation);
            return this.derivative(x);
        }

        public final double secondDerivative(double x, boolean allowExtrapolation) {
            AbstractInterpolation.this.checkRange(x, allowExtrapolation);
            return this.secondDerivative(x);
        }

        public abstract void update();

        public abstract double op(double var1);

        public abstract double primitive(double var1);

        public abstract double derivative(double var1);

        public abstract double secondDerivative(double var1);

        protected int locate(double x) {
            QL.require(this.extraSafetyChecks(), "unsorted values on array X");
            if (x < this.vx.first()) {
                return 0;
            }
            if (x > this.vx.last()) {
                return this.vx.size() - 2;
            }
            int ub = this.vx.upperBound(this.vx.begin(), this.vx.end() - 1, x) - 1;
            return ub;
        }

        private boolean extraSafetyChecks() {
            if (new Settings().isExtraSafetyChecks()) {
                for (int i = 0; i < this.vx.size() - 1; ++i) {
                    if (!(this.vx.get(i) > this.vx.get(i + 1))) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

