/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.integrals;

import org.jquantlib.QL;
import org.jquantlib.math.Ops;
import org.jquantlib.math.integrals.KronrodIntegral;

public class GaussKronrodAdaptive
extends KronrodIntegral {
    private static final double[] g7w = new double[]{0.417959183673469, 0.381830050505119, 0.279705391489277, 0.12948496616887};
    private static final double[] k15w = new double[]{0.209482141084728, 0.204432940075298, 0.190350578064785, 0.169004726639267, 0.140653259715525, 0.10479001032225, 0.063092092629979, 0.022935322010529};
    private static final double[] k15t = new double[]{0.0, 0.207784955007898, 0.405845151377397, 0.586087235467691, 0.741531185599394, 0.864864423359769, 0.949107912342758, 0.991455371120813};

    public GaussKronrodAdaptive(double absoluteAccuracy, int maxEvaluations) {
        super(absoluteAccuracy, maxEvaluations);
        QL.require(maxEvaluations >= 15, "required maxEvaluations must be >= 15");
    }

    @Override
    protected double integrate(Ops.DoubleOp f, double a, double b) {
        return this.integrateRecursively(f, a, b, this.absoluteAccuracy());
    }

    private double integrateRecursively(Ops.DoubleOp f, double a, double b, double tolerance) {
        double fsum;
        double t;
        double halflength = (b - a) / 2.0;
        double center = (a + b) / 2.0;
        double fc = f.op(center);
        double g7 = fc * g7w[0];
        double k15 = fc * k15w[0];
        int j = 1;
        int j2 = 2;
        while (j < 4) {
            t = halflength * k15t[j2];
            fsum = f.op(center - t) + f.op(center + t);
            g7 += fsum * g7w[j];
            k15 += fsum * k15w[j2];
            ++j;
            j2 += 2;
        }
        for (j2 = 1; j2 < 8; j2 += 2) {
            t = halflength * k15t[j2];
            fsum = f.op(center - t) + f.op(center + t);
            k15 += fsum * k15w[j2];
        }
        g7 = halflength * g7;
        k15 = halflength * k15;
        this.increaseNumberOfEvaluations(15);
        if (Math.abs(k15 - g7) < tolerance) {
            return k15;
        }
        QL.require(this.numberOfEvaluations() + 30 <= this.maxEvaluations(), "maximum number of function evaluations exceeded");
        return this.integrateRecursively(f, a, center, tolerance / 2.0) + this.integrateRecursively(f, center, b, tolerance / 2.0);
    }
}

