/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.distributions;

import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.Closeness;
import org.jquantlib.math.Constants;
import org.jquantlib.math.distributions.CumulativeNormalDistribution;
import org.jquantlib.math.randomnumbers.InverseCumulative;

public class InverseCumulativeNormal
implements InverseCumulative {
    private static final String SIGMA_MUST_BE_POSITIVE = "sigma must be greater than 0.0";
    private static final double a1 = -39.69683028665376;
    private static final double a2 = 220.9460984245205;
    private static final double a3 = -275.9285104469687;
    private static final double a4 = 138.357751867269;
    private static final double a5 = -30.66479806614716;
    private static final double a6 = 2.506628277459239;
    private static final double b1 = -54.47609879822406;
    private static final double b2 = 161.5858368580409;
    private static final double b3 = -155.6989798598866;
    private static final double b4 = 66.80131188771972;
    private static final double b5 = -13.28068155288572;
    private static final double c1 = -0.007784894002430293;
    private static final double c2 = -0.3223964580411365;
    private static final double c3 = -2.400758277161838;
    private static final double c4 = -2.549732539343734;
    private static final double c5 = 4.374664141464968;
    private static final double c6 = 2.938163982698783;
    private static final double d1 = 0.007784695709041462;
    private static final double d2 = 0.3224671290700398;
    private static final double d3 = 2.445134137142996;
    private static final double d4 = 3.754408661907416;
    private static final double xlow = 0.02425;
    private static final double xhigh = 0.97575;
    protected double average;
    protected double sigma;
    private final boolean highPrecision;

    public InverseCumulativeNormal() {
        this(0.0);
    }

    public InverseCumulativeNormal(double average) {
        this(average, 1.0);
    }

    public InverseCumulativeNormal(double average, double sigma) {
        QL.require(sigma > 0.0, SIGMA_MUST_BE_POSITIVE);
        this.average = average;
        this.sigma = sigma;
        this.highPrecision = new Settings().isRefineHighPrecisionUsingHalleysMethod();
    }

    @Override
    public double op(double x) {
        double r;
        double z;
        QL.require(this.sigma > 0.0, SIGMA_MUST_BE_POSITIVE);
        if (x < 0.0 || x > 1.0) {
            if (Closeness.isCloseEnough(x, 1.0)) {
                x = 1.0;
            } else if (Math.abs(x) < Constants.QL_EPSILON) {
                x = 0.0;
            } else {
                throw new LibraryException(SIGMA_MUST_BE_POSITIVE);
            }
        }
        if (x < 0.02425) {
            z = Math.sqrt(-2.0 * Math.log(x));
            z = (((((-0.007784894002430293 * z + -0.3223964580411365) * z + -2.400758277161838) * z + -2.549732539343734) * z + 4.374664141464968) * z + 2.938163982698783) / ((((0.007784695709041462 * z + 0.3224671290700398) * z + 2.445134137142996) * z + 3.754408661907416) * z + 1.0);
        } else if (x <= 0.97575) {
            z = x - 0.5;
            r = z * z;
            z = (((((-39.69683028665376 * r + 220.9460984245205) * r + -275.9285104469687) * r + 138.357751867269) * r + -30.66479806614716) * r + 2.506628277459239) * z / (((((-54.47609879822406 * r + 161.5858368580409) * r + -155.6989798598866) * r + 66.80131188771972) * r + -13.28068155288572) * r + 1.0);
        } else {
            z = Math.sqrt(-2.0 * Math.log(1.0 - x));
            z = -(((((-0.007784894002430293 * z + -0.3223964580411365) * z + -2.400758277161838) * z + -2.549732539343734) * z + 4.374664141464968) * z + 2.938163982698783) / ((((0.007784695709041462 * z + 0.3224671290700398) * z + 2.445134137142996) * z + 3.754408661907416) * z + 1.0);
        }
        if (this.highPrecision) {
            CumulativeNormalDistribution f_ = new CumulativeNormalDistribution();
            r = (f_.op(z) - x) * 1.4142135623730951 * 1.772453850905516 * Math.exp(0.5 * z * z);
            z -= r / (1.0 + 0.5 * z * r);
        }
        return this.average + z * this.sigma;
    }
}

