/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments.bonds;

import java.util.List;
import org.jquantlib.cashflow.Callability;
import org.jquantlib.cashflow.Dividend;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.Bond;
import org.jquantlib.instruments.Option;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.time.Date;
import org.jquantlib.time.Schedule;

public class ConvertibleBond
extends Bond {
    protected double conversionRatio;
    protected List<Dividend> dividends;
    protected List<Callability> callability;
    protected Handle<Quote> creditSpread;
    protected Option option;

    public ConvertibleBond(Exercise exercise, double conversionRatio, List<Dividend> dividends, List<Callability> callability, Handle<Quote> creditSpread, Date issueDate, int settlementDays, DayCounter dayCounter, Schedule schedule, double redemption) {
        super(settlementDays, schedule.calendar(), issueDate);
        this.conversionRatio = conversionRatio;
        this.callability = callability;
        this.dividends = dividends;
        this.creditSpread = creditSpread;
        this.maturityDate_ = schedule.endDate().clone();
        creditSpread.addObserver(this);
    }

    public double conversionRatio() {
        return this.conversionRatio;
    }

    public List<Dividend> dividends() {
        return this.dividends;
    }

    public List<Callability> callability() {
        return this.callability;
    }

    public Handle<Quote> creditSpread() {
        return this.creditSpread;
    }

    @Override
    protected void performCalculations() {
        this.option.setPricingEngine(this.engine);
        this.NPV = this.settlementValue_ = this.option.NPV();
        this.errorEstimate = Double.MAX_VALUE;
    }
}

