/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import org.jquantlib.instruments.Instrument;
import org.jquantlib.instruments.PriceError;
import org.jquantlib.math.solvers1D.Brent;
import org.jquantlib.pricingengines.PricingEngine;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.BlackVolTermStructure;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.volatilities.BlackConstantVol;

public class ImpliedVolatilityHelper {
    public static double calculate(Instrument instrument, PricingEngine engine, SimpleQuote volQuote, double targetValue, double accuracy, int maxEvaluations, double minVol, double maxVol) {
        instrument.setupArguments(engine.getArguments());
        engine.getArguments().validate();
        PriceError f = new PriceError(engine, volQuote, targetValue);
        Brent solver = new Brent();
        solver.setMaxEvaluations(maxEvaluations);
        double guess = (minVol + maxVol) / 2.0;
        double result = solver.solve(f, accuracy, guess, minVol, maxVol);
        return result;
    }

    public static GeneralizedBlackScholesProcess clone(GeneralizedBlackScholesProcess process, SimpleQuote volQuote) {
        Handle<? extends Quote> stateVariable = process.stateVariable();
        Handle<YieldTermStructure> dividendYield = process.dividendYield();
        Handle<YieldTermStructure> riskFreeRate = process.riskFreeRate();
        Handle<BlackVolTermStructure> blackVol = process.blackVolatility();
        Handle<BlackVolTermStructure> volatility = new Handle<BlackVolTermStructure>(new BlackConstantVol(blackVol.currentLink().referenceDate(), blackVol.currentLink().calendar(), new Handle<SimpleQuote>(volQuote), blackVol.currentLink().dayCounter()));
        return new GeneralizedBlackScholesProcess(stateVariable, dividendYield, riskFreeRate, volatility);
    }
}

