/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.cashflow.Dividend;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.ImpliedVolatilityHelper;
import org.jquantlib.instruments.OneAssetOption;
import org.jquantlib.instruments.Payoff;
import org.jquantlib.instruments.VanillaOption;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.pricingengines.PricingEngine;
import org.jquantlib.pricingengines.vanilla.AnalyticDividendEuropeanEngine;
import org.jquantlib.pricingengines.vanilla.finitedifferences.FDDividendAmericanEngine;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.time.Date;

public class DividendVanillaOption
extends VanillaOption {
    private static final String WRONG_ARGUMENT_TYPE = "wrong argument type";
    private final List<? extends Dividend> cashFlow;

    public DividendVanillaOption(Payoff payoff, Exercise exercise, List<Date> dates, List<Double> dividends) {
        super(payoff, exercise);
        this.cashFlow = Dividend.DividendVector(dates, dividends);
    }

    @Override
    public double impliedVolatility(double price, GeneralizedBlackScholesProcess process) {
        return this.impliedVolatility(price, process, 1.0E-4, 100, 1.0E-7, 4.0);
    }

    @Override
    public double impliedVolatility(double price, GeneralizedBlackScholesProcess process, double accuracy) {
        return this.impliedVolatility(price, process, accuracy, 100, 1.0E-7, 4.0);
    }

    @Override
    public double impliedVolatility(double price, GeneralizedBlackScholesProcess process, double accuracy, int maxEvaluations) {
        return this.impliedVolatility(price, process, accuracy, maxEvaluations, 1.0E-7, 4.0);
    }

    @Override
    public double impliedVolatility(double price, GeneralizedBlackScholesProcess process, double accuracy, int maxEvaluations, double minVol) {
        return this.impliedVolatility(price, process, accuracy, maxEvaluations, minVol, 4.0);
    }

    @Override
    public double impliedVolatility(double targetValue, GeneralizedBlackScholesProcess process, double accuracy, int maxEvaluations, double minVol, double maxVol) {
        VanillaOption.Engine engine;
        QL.require(!this.isExpired(), "option expired");
        SimpleQuote volQuote = new SimpleQuote();
        GeneralizedBlackScholesProcess newProcess = ImpliedVolatilityHelper.clone(process, volQuote);
        switch (this.exercise.type()) {
            case European: {
                engine = new AnalyticDividendEuropeanEngine(newProcess);
                break;
            }
            case American: {
                engine = new FDDividendAmericanEngine(newProcess);
                break;
            }
            case Bermudan: {
                throw new LibraryException("engine not available for Bermudan option with dividends");
            }
            default: {
                throw new LibraryException("unknown exercise type");
            }
        }
        return ImpliedVolatilityHelper.calculate(this, engine, volQuote, targetValue, accuracy, maxEvaluations, minVol, maxVol);
    }

    @Override
    public void setupArguments(PricingEngine.Arguments args) {
        QL.require(ArgumentsImpl.class.isAssignableFrom(args.getClass()), "Unexpected type for type parameter");
        super.setupArguments(args);
        ArgumentsImpl arguments = (ArgumentsImpl)args;
        arguments.cashFlow = this.cashFlow;
    }

    public static abstract class EngineImpl
    extends VanillaOption.EngineImpl
    implements VanillaOption.Engine {
        protected EngineImpl() {
            super(new ArgumentsImpl(), new ResultsImpl());
        }
    }

    public static class ResultsImpl
    extends OneAssetOption.ResultsImpl
    implements OneAssetOption.Results {
    }

    public static class ArgumentsImpl
    extends OneAssetOption.ArgumentsImpl
    implements OneAssetOption.Arguments {
        public List<? extends Dividend> cashFlow;

        @Override
        public void validate() {
            super.validate();
            Date exerciseDate = this.exercise.lastDate();
            for (int i = 0; i < this.cashFlow.size(); ++i) {
                Date d = this.cashFlow.get(i).date();
                QL.require(d.le(exerciseDate), "dividend date later than the exercise date");
            }
        }
    }
}

