/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.DiscretizedAsset;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.functions.Bind2ndPredicate;
import org.jquantlib.math.functions.FindIf;
import org.jquantlib.math.functions.GreaterEqualPredicate;
import org.jquantlib.math.matrixutilities.Array;

public class DiscretizedOption
extends DiscretizedAsset {
    protected Exercise.Type exerciseType;
    protected Array exerciseTimes;
    protected DiscretizedAsset underlying;

    public DiscretizedOption(DiscretizedAsset underlying, Exercise.Type exerciseType, Array exerciseTimes) {
        this.underlying = underlying;
        this.exerciseType = exerciseType;
        this.exerciseTimes = exerciseTimes;
    }

    @Override
    public void reset(int size) {
        QL.require(this.method().equals(this.underlying.method()), "option and underlying were initialized on different methods");
        this.values_ = new Array(size);
        this.adjustValues();
    }

    @Override
    public List<Double> mandatoryTimes() {
        List<Double> times = this.underlying.mandatoryTimes();
        Array array = new FindIf(this.exerciseTimes, new Bind2ndPredicate(new GreaterEqualPredicate(), 0.0)).op();
        for (int i = 0; i < array.size(); ++i) {
            times.add(array.get(i));
        }
        return times;
    }

    protected void applyExerciseCondition() {
        for (int i = 0; i < this.values_.size(); ++i) {
            this.values_.set(i, Math.max(this.underlying.values().get(i), this.values_.get(i)));
        }
    }

    @Override
    public void postAdjustValuesImpl() {
        this.underlying.partialRollback(this.time());
        this.underlying.preAdjustValues();
        switch (this.exerciseType) {
            case American: {
                if (!(this.time >= this.exerciseTimes.get(0)) || !(this.time <= this.exerciseTimes.get(1))) break;
                this.applyExerciseCondition();
                break;
            }
            case Bermudan: 
            case European: {
                for (int i = 0; i < this.exerciseTimes.size(); ++i) {
                    double t = this.exerciseTimes.get(i);
                    if (!(t >= 0.0) || !this.isOnTime(t)) continue;
                    this.applyExerciseCondition();
                }
                break;
            }
            default: {
                throw new LibraryException("invalid exercise type");
            }
        }
        this.underlying.postAdjustValues();
    }
}

