/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.indexes;

import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.currencies.Currency;
import org.jquantlib.indexes.IndexManager;
import org.jquantlib.indexes.InflationIndex;
import org.jquantlib.indexes.Region;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.InflationTermStructure;
import org.jquantlib.termstructures.ZeroInflationTermStructure;
import org.jquantlib.time.Date;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.Period;
import org.jquantlib.util.Pair;

public abstract class ZeroInflationIndex
extends InflationIndex {
    private Handle<ZeroInflationTermStructure> zeroInflation;

    public ZeroInflationIndex(String familyName, Region region, boolean revised, boolean interpolated, Frequency frequency, Period availabilityLag, Currency currency) {
        this(familyName, region, revised, interpolated, frequency, availabilityLag, currency, new Handle<ZeroInflationTermStructure>());
    }

    public ZeroInflationIndex(String familyName, Region region, boolean revised, boolean interpolated, Frequency frequency, Period availabilityLag, Currency currency, Handle<ZeroInflationTermStructure> zeroInflation) {
        super(familyName, region, revised, interpolated, frequency, availabilityLag, currency);
        this.zeroInflation = zeroInflation;
        this.zeroInflation.addObserver(this);
    }

    @Override
    public double fixing(Date fixingDate) {
        return this.fixing(fixingDate, false);
    }

    @Override
    public double fixing(Date fixingDate, boolean forecastTodaysFixing) {
        Date today = new Settings().evaluationDate();
        Date todayMinusLag = today.sub(this.availabilityLag);
        Pair<Date, Date> lim = InflationTermStructure.inflationPeriod(todayMinusLag, this.frequency);
        if (fixingDate.lt(todayMinusLag = lim.second().inc()) || fixingDate.eq(todayMinusLag) && !forecastTodaysFixing) {
            double pastFixing = (Double)IndexManager.getInstance().getHistory(this.name()).get(fixingDate);
            QL.require(!Double.isNaN(pastFixing), "Missing " + this.name() + " fixing for " + fixingDate);
            return pastFixing;
        }
        return this.forecastFixing(fixingDate);
    }

    public Handle<ZeroInflationTermStructure> zeroInflationTermStructure() {
        return this.zeroInflation;
    }

    private double forecastFixing(Date fixingDate) {
        Date baseDate = this.zeroInflation.currentLink().baseDate();
        double baseFixing = this.fixing(baseDate);
        Pair<Date, Date> limBase = InflationTermStructure.inflationPeriod(baseDate, this.frequency);
        Date trueBaseDate = limBase.second();
        Date d = fixingDate;
        if (!this.interpolated()) {
            Pair<Date, Date> lim = InflationTermStructure.inflationPeriod(fixingDate, this.frequency);
            int n = (int)lim.second().sub(lim.first()) / 2;
            d = lim.first().add(n);
        }
        double zero = this.zeroInflation.currentLink().zeroRate(d);
        double t = this.zeroInflation.currentLink().dayCounter().yearFraction(trueBaseDate, d);
        return baseFixing * Math.pow(1.0 + zero, t);
    }
}

