/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.indexes;

import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.currencies.Currency;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.Index;
import org.jquantlib.indexes.IndexManager;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.util.Observer;

public abstract class InterestRateIndex
extends Index
implements Observer {
    protected String familyName;
    protected Period tenor;
    protected int fixingDays;
    protected Calendar fixingCalendar;
    protected Currency currency;
    protected DayCounter dayCounter;

    public InterestRateIndex(String familyName, Period tenor, int fixingDays, Currency currency, Calendar fixingCalendar, DayCounter dayCounter) {
        this.familyName = familyName;
        this.tenor = tenor;
        this.fixingDays = fixingDays;
        this.fixingCalendar = fixingCalendar;
        this.currency = currency;
        this.dayCounter = dayCounter;
        this.tenor.normalize();
        new Settings().evaluationDate().addObserver(this);
        IndexManager.getInstance().notifier(this.name()).addObserver(this);
    }

    @Override
    public String name() {
        StringBuilder builder = new StringBuilder(this.familyName);
        if (this.tenor.equals(new Period(1, TimeUnit.Days))) {
            if (this.fixingDays == 0) {
                builder.append("ON");
            } else if (this.fixingDays == 1) {
                builder.append("TN");
            } else if (this.fixingDays == 2) {
                builder.append("SN");
            } else {
                builder.append(this.tenor.getShortFormat());
            }
        } else {
            builder.append(this.tenor.getShortFormat());
        }
        builder.append(' ').append(this.dayCounter.name());
        return builder.toString();
    }

    @Override
    public Calendar fixingCalendar() {
        return this.fixingCalendar;
    }

    @Override
    public boolean isValidFixingDate(Date fixingDate) {
        return this.fixingCalendar.isBusinessDay(fixingDate);
    }

    public String familyName() {
        return this.familyName;
    }

    public Period tenor() {
        return this.tenor;
    }

    public int fixingDays() {
        return this.fixingDays;
    }

    public Currency currency() {
        return this.currency;
    }

    public DayCounter dayCounter() {
        return this.dayCounter;
    }

    protected abstract double forecastFixing(Date var1);

    public abstract Handle<YieldTermStructure> termStructure();

    public abstract Date maturityDate(Date var1);

    @Override
    public double fixing(Date fixingDate, boolean forecastTodaysFixing) {
        QL.require(this.isValidFixingDate(fixingDate), "Fixing date " + fixingDate.toString() + " is not valid");
        Date today = new Settings().evaluationDate();
        boolean enforceTodaysHistoricFixings = new Settings().isEnforcesTodaysHistoricFixings();
        if (fixingDate.lt(today) || fixingDate.equals(today) && enforceTodaysHistoricFixings && !forecastTodaysFixing) {
            double pastFixing = (Double)IndexManager.getInstance().getHistory(this.name()).get(fixingDate);
            QL.require(pastFixing != Double.MAX_VALUE, "Missing " + this.name() + " fixing for " + fixingDate);
            return pastFixing;
        }
        if (fixingDate.equals(today) && !forecastTodaysFixing) {
            try {
                double pastFixing = (Double)IndexManager.getInstance().getHistory(this.name()).get(fixingDate);
                if (pastFixing != Double.MAX_VALUE) {
                    return pastFixing;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.forecastFixing(fixingDate);
    }

    @Override
    public double fixing(Date fixingDate) {
        return this.fixing(fixingDate, false);
    }

    public Date fixingDate(Date valueDate) {
        Date fixingDate = this.fixingCalendar().advance(valueDate, this.fixingDays, TimeUnit.Days);
        QL.ensure(this.isValidFixingDate(fixingDate), "fixing date " + fixingDate + " is not valid");
        return fixingDate;
    }

    public Date valueDate(Date fixingDate) {
        QL.require(this.isValidFixingDate(fixingDate), "Fixing date is not valid");
        return this.fixingCalendar().advance(fixingDate, this.fixingDays, TimeUnit.Days);
    }

    @Override
    public void update() {
        this.notifyObservers();
    }
}

