/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.indexes;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jquantlib.time.TimeSeries;
import org.jquantlib.util.Observable;
import org.jquantlib.util.ObservableValue;

public class IndexManager {
    private static final long serialVersionUID = -9204254124065694863L;
    private static Map<String, TimeSeries<Double>> data;
    private static volatile IndexManager instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IndexManager getInstance() {
        if (instance != null) return instance;
        Class<IndexManager> clazz = IndexManager.class;
        synchronized (IndexManager.class) {
            if (instance != null) return instance;
            instance = new IndexManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private IndexManager() {
        data = new ConcurrentHashMap<String, TimeSeries<Double>>();
    }

    public TimeSeries<Double> getHistory(String name) {
        return data.get(name);
    }

    public void setHistory(String name, TimeSeries<Double> history) {
        data.put(name, history);
    }

    public void clearHistory(String name) {
        data.remove(name);
    }

    public void clearHistories() {
        data.clear();
    }

    public Observable notifier(String name) {
        TimeSeries<Double> value = data.get(name);
        if (value == null) {
            value = new TimeSeries<Double>(Double.class);
            data.put(name, value);
        }
        return new ObservableValue<TimeSeries<Double>>(value);
    }
}

