/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.experimental.lattices;

import org.jquantlib.QL;
import org.jquantlib.experimental.lattices.ExtendedBinomialTree;
import org.jquantlib.processes.StochasticProcess1D;

public class ExtendedTian
extends ExtendedBinomialTree {
    private final double up_;
    private final double down_;
    private final double pu_;
    private final double pd_;

    public ExtendedTian(StochasticProcess1D process, double end, int steps) {
        super(process, end, steps);
        double q = Math.exp(process.variance(0.0, this.x0, this.dt));
        double r = Math.exp(this.driftStep(0.0)) * Math.sqrt(q);
        this.up_ = 0.5 * r * q * (q + 1.0 + Math.sqrt(q * q + 2.0 * q - 3.0));
        this.down_ = 0.5 * r * q * (q + 1.0 - Math.sqrt(q * q + 2.0 * q - 3.0));
        this.pu_ = (r - this.down_) / (this.up_ - this.down_);
        this.pd_ = 1.0 - this.pu_;
        QL.require(this.pu_ <= 1.0, "negative probability");
        QL.require(this.pu_ >= 0.0, "negative probability");
    }

    @Override
    public double underlying(int i, int index) {
        double stepTime = (double)i * this.dt;
        double q = Math.exp(this.treeProcess.variance(stepTime, this.x0, this.dt));
        double r = Math.exp(this.driftStep(stepTime)) * Math.sqrt(q);
        double up = 0.5 * r * q * (q + 1.0 + Math.sqrt(q * q + 2.0 * q - 3.0));
        double down = 0.5 * r * q * (q + 1.0 - Math.sqrt(q * q + 2.0 * q - 3.0));
        return this.x0 * Math.pow(down, i - index) * Math.pow(up, index);
    }

    @Override
    public double probability(int i, int ref, int branch) {
        double stepTime = (double)i * this.dt;
        double q = Math.exp(this.treeProcess.variance(stepTime, this.x0, this.dt));
        double r = Math.exp(this.driftStep(stepTime)) * Math.sqrt(q);
        double up = 0.5 * r * q * (q + 1.0 + Math.sqrt(q * q + 2.0 * q - 3.0));
        double down = 0.5 * r * q * (q + 1.0 - Math.sqrt(q * q + 2.0 * q - 3.0));
        double pu = (r - down) / (up - down);
        double pd = 1.0 - pu;
        return branch == 1 ? pu : pd;
    }
}

