/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.daycounters;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.calendars.Brazil;

@QualityAssurance(quality=QualityAssurance.Quality.Q4_UNIT, version=QualityAssurance.Version.V097, reviewers={"Richard Gomes"})
public class Business252
extends DayCounter {
    public Business252() {
        this(new Brazil());
    }

    public Business252(Calendar calendar) {
        this.impl = new Impl(calendar);
    }

    private final class Impl
    extends DayCounter.Impl {
        private final Calendar calendar;

        private Impl(Calendar calendar) {
            super(Business252.this);
            this.calendar = calendar;
        }

        @Override
        public final String name() {
            return "Business/252(" + this.calendar.name() + ")";
        }

        @Override
        public long dayCount(Date d1, Date d2) {
            return this.calendar.businessDaysBetween(d1, d2);
        }

        @Override
        public final double yearFraction(Date dateStart, Date dateEnd, Date refPeriodStart, Date refPeriodEnd) {
            return (double)this.dayCount(dateStart, dateEnd) / 252.0;
        }
    }
}

