/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.cashflow;

import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.cashflow.CashFlow;
import org.jquantlib.cashflow.CmsCoupon;
import org.jquantlib.cashflow.CmsCouponPricer;
import org.jquantlib.cashflow.Coupon;
import org.jquantlib.cashflow.FloatingRateCouponPricer;
import org.jquantlib.cashflow.IborCoupon;
import org.jquantlib.cashflow.IborCouponPricer;
import org.jquantlib.cashflow.Leg;
import org.jquantlib.cashflow.SimpleCashFlow;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

@QualityAssurance(quality=QualityAssurance.Quality.Q0_UNFINISHED, version=QualityAssurance.Version.V097, reviewers={"Richard Gomes"})
public class PricerSetter
implements PolymorphicVisitor {
    private static final String INCOMPATIBLE_PRICER = "incompatible pricer";
    private static final String UNKNOWN_VISITABLE = "unknown visitable";
    private final FloatingRateCouponPricer pricer;

    public PricerSetter(FloatingRateCouponPricer pricer) {
        this.pricer = pricer;
    }

    public static void setCouponPricer(Leg leg, FloatingRateCouponPricer pricer) {
        PricerSetter setter = new PricerSetter(pricer);
        for (int i = 0; i < leg.size(); ++i) {
            ((CashFlow)leg.get(i)).accept(setter);
        }
    }

    public static void setCouponPricers(Leg leg, List<FloatingRateCouponPricer> pricers) {
        QL.require(leg.size() > 0, "no cashflows");
        QL.require(leg.size() == pricers.size(), "mismatch between leg size and number of pricers");
        int nCashFlows = leg.size();
        int nPricers = pricers.size();
        for (int i = 0; i < nCashFlows; ++i) {
            PricerSetter setter = new PricerSetter(i < nPricers ? pricers.get(i) : pricers.get(nPricers - 1));
            ((CashFlow)leg.get(i)).accept(setter);
        }
    }

    public <CashFlow> Visitor<CashFlow> visitor(Class<? extends CashFlow> klass) {
        if (klass == CashFlow.class) {
            return new CashFlowVisitor();
        }
        if (klass == SimpleCashFlow.class) {
            return new SimpleCashFlowVisitor();
        }
        if (klass == Coupon.class) {
            return new CouponVisitor();
        }
        if (klass == IborCoupon.class) {
            return new IborCouponVisitor();
        }
        if (klass == CmsCoupon.class) {
            return new CmsCouponVisitor();
        }
        throw new LibraryException(UNKNOWN_VISITABLE);
    }

    private class CmsCouponVisitor
    implements Visitor<CashFlow> {
        private CmsCouponVisitor() {
        }

        @Override
        public void visit(CashFlow o) {
            if (!CmsCouponPricer.class.isAssignableFrom(PricerSetter.this.pricer.getClass())) {
                throw new LibraryException(PricerSetter.INCOMPATIBLE_PRICER);
            }
            CmsCoupon c = (CmsCoupon)o;
            c.setPricer((CmsCouponPricer)PricerSetter.this.pricer);
        }
    }

    private class IborCouponVisitor
    implements Visitor<CashFlow> {
        private IborCouponVisitor() {
        }

        @Override
        public void visit(CashFlow o) {
            if (!IborCouponPricer.class.isAssignableFrom(PricerSetter.this.pricer.getClass())) {
                throw new LibraryException(PricerSetter.INCOMPATIBLE_PRICER);
            }
            IborCoupon c = (IborCoupon)o;
            c.setPricer(PricerSetter.this.pricer);
        }
    }

    private class CouponVisitor
    implements Visitor<CashFlow> {
        private CouponVisitor() {
        }

        @Override
        public void visit(CashFlow o) {
        }
    }

    private class SimpleCashFlowVisitor
    implements Visitor<CashFlow> {
        private SimpleCashFlowVisitor() {
        }

        @Override
        public void visit(CashFlow o) {
        }
    }

    private class CashFlowVisitor
    implements Visitor<CashFlow> {
        private CashFlowVisitor() {
        }

        @Override
        public void visit(CashFlow o) {
        }
    }
}

