/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.cashflow;

import java.util.ArrayList;
import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.cashflow.CashFlow;
import org.jquantlib.cashflow.FixedDividend;
import org.jquantlib.time.Date;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

public abstract class Dividend
extends CashFlow {
    protected Date date;

    public Dividend(Date date) {
        this.date = date;
    }

    @Override
    public Date date() {
        return this.date;
    }

    public abstract double amount(double var1);

    public static List<? extends Dividend> DividendVector(List<Date> dividendDates, List<Double> dividends) {
        QL.require(dividendDates.size() == dividends.size(), "size mismatch between dividend dates and amounts");
        ArrayList<FixedDividend> items = new ArrayList<FixedDividend>(dividendDates.size());
        for (int i = 0; i < dividendDates.size(); ++i) {
            items.add(new FixedDividend(dividends.get(i), dividendDates.get(i)));
        }
        return items;
    }

    @Override
    public void accept(PolymorphicVisitor pv) {
        Visitor<?> v;
        Visitor<?> visitor = v = pv != null ? pv.visitor(this.getClass()) : null;
        if (v != null) {
            v.visit(this);
        } else {
            super.accept(pv);
        }
    }
}

