/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import org.fife.ui.rsyntaxtextarea.DefaultToken;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class VisibleWhitespaceToken
extends DefaultToken {
    private Rectangle2D.Float dotRect;

    public VisibleWhitespaceToken() {
        this.dotRect = new Rectangle2D.Float(0.0f, 0.0f, 1.0f, 1.0f);
    }

    public VisibleWhitespaceToken(Segment line, int beg, int end, int startOffset, int type) {
        this(line.array, beg, end, startOffset, type);
    }

    public VisibleWhitespaceToken(char[] line, int beg, int end, int startOffset, int type) {
        super(line, beg, end, startOffset, type);
    }

    @Override
    public final float paint(Graphics2D g, float x, float y, RSyntaxTextArea host, TabExpander e, float clipStart) {
        int origX = (int)x;
        int end = this.textOffset + this.textCount;
        float nextX = x;
        int flushLen = 0;
        int flushIndex = this.textOffset;
        Color fg = host.getForegroundForToken(this);
        Color bg = host.getBackgroundForTokenType(this.type);
        g.setFont(host.getFontForTokenType(this.type));
        FontMetrics fm = host.getFontMetricsForTokenType(this.type);
        int ascent = fm.getAscent();
        int height = fm.getHeight();
        block4: for (int i = this.textOffset; i < end; ++i) {
            switch (this.text[i]) {
                case '\t': {
                    nextX = x + (float)fm.charsWidth(this.text, flushIndex, flushLen);
                    float nextNextX = e.nextTabStop(nextX, 0);
                    if (bg != null) {
                        this.paintBackground(x, y, nextNextX - x, height, g, ascent, host, bg);
                    }
                    g.setColor(fg);
                    if (flushLen > 0) {
                        g.drawChars(this.text, flushIndex, flushLen, (int)x, (int)y);
                        flushLen = 0;
                    }
                    flushIndex = i + 1;
                    int halfHeight = height / 2;
                    int quarterHeight = halfHeight / 2;
                    int ymid = (int)y - ascent + halfHeight;
                    g.drawLine((int)nextX, ymid, (int)nextNextX, ymid);
                    g.drawLine((int)nextNextX, ymid, (int)nextNextX - 4, ymid - quarterHeight);
                    g.drawLine((int)nextNextX, ymid, (int)nextNextX - 4, ymid + quarterHeight);
                    x = nextNextX;
                    continue block4;
                }
                case ' ': {
                    nextX = x + (float)fm.charsWidth(this.text, flushIndex, flushLen + 1);
                    int width = fm.charWidth(' ');
                    if (bg != null) {
                        this.paintBackground(x, y, nextX - x, height, g, ascent, host, bg);
                    }
                    g.setColor(fg);
                    if (flushLen > 0) {
                        g.drawChars(this.text, flushIndex, flushLen, (int)x, (int)y);
                        flushLen = 0;
                    }
                    this.dotRect.x = nextX - (float)width / 2.0f;
                    this.dotRect.y = y - (float)ascent + (float)height / 2.0f;
                    g.fill(this.dotRect);
                    flushIndex = i + 1;
                    x = nextX;
                    continue block4;
                }
                default: {
                    ++flushLen;
                }
            }
        }
        nextX = x + (float)fm.charsWidth(this.text, flushIndex, flushLen);
        if (flushLen > 0 && nextX >= clipStart) {
            if (bg != null) {
                this.paintBackground(x, y, nextX - x, height, g, ascent, host, bg);
            }
            g.setColor(fg);
            g.drawChars(this.text, flushIndex, flushLen, (int)x, (int)y);
        }
        if (host.getUnderlineForToken(this)) {
            g.setColor(fg);
            int y2 = (int)(y + 1.0f);
            g.drawLine(origX, y2, (int)nextX, y2);
        }
        if (host.getPaintTabLines() && origX == host.getMargin().left) {
            this.paintTabLines(origX, (int)y, (int)nextX, g, e, host);
        }
        return nextX;
    }
}

