/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.fife.ui.rsyntaxtextarea.ChangeableColorHighlightPainter;

class MarkOccurrencesHighlightPainter
extends ChangeableColorHighlightPainter {
    private Color borderColor;
    private boolean paintBorder;

    public MarkOccurrencesHighlightPainter() {
        super(Color.BLUE);
    }

    public boolean getPaintBorder() {
        return this.paintBorder;
    }

    @Override
    public Shape paintLayer(Graphics g, int p0, int p1, Shape viewBounds, JTextComponent c, View view) {
        g.setColor(this.getColor());
        if (p0 == ++p1) {
            try {
                Shape s = view.modelToView(p0, viewBounds, Position.Bias.Forward);
                Rectangle r = s.getBounds();
                g.drawLine(r.x, r.y, r.x, r.y + r.height);
                return r;
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                return null;
            }
        }
        if (p0 == view.getStartOffset() && p1 == view.getEndOffset()) {
            Rectangle alloc = viewBounds instanceof Rectangle ? (Rectangle)viewBounds : viewBounds.getBounds();
            g.fillRect(alloc.x, alloc.y, alloc.width, alloc.height);
            return alloc;
        }
        Graphics2D g2d = (Graphics2D)g;
        try {
            Shape shape = view.modelToView(p0, Position.Bias.Forward, p1, Position.Bias.Backward, viewBounds);
            Rectangle r = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            g2d.fillRect(r.x, r.y, r.width, r.height);
            if (this.paintBorder) {
                g2d.setColor(this.borderColor);
                g2d.drawRect(r.x, r.y, r.width - 1, r.height - 1);
            }
            return r;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setColor(Color c) {
        super.setColor(c);
        this.borderColor = c.darker();
    }

    public void setPaintBorder(boolean paint) {
        this.paintBorder = paint;
    }
}

