/*
 * Decompiled with CFR 0.152.
 */
package net.doodleproject.numerics4j.statistics.distribution;

import net.doodleproject.numerics4j.exception.NumericException;
import net.doodleproject.numerics4j.special.Beta;
import net.doodleproject.numerics4j.statistics.distribution.ContinuousDistribution;

public class BetaDistribution
extends ContinuousDistribution {
    private double alpha;
    private double beta;

    public BetaDistribution() {
        this(1.0, 1.0);
    }

    public BetaDistribution(double a, double b) {
        this.setAlpha(a);
        this.setBeta(b);
    }

    @Override
    public double cumulativeProbability(double x) throws NumericException {
        double ret = Double.isNaN(x) ? Double.NaN : (x <= 0.0 ? 0.0 : (x >= 1.0 ? 1.0 : Beta.regularizedBeta(x, this.getAlpha(), this.getBeta())));
        return ret;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    @Override
    public double inverseCumulativeProbability(double p) throws NumericException {
        double ret = p < 0.0 || p > 1.0 || Double.isNaN(p) ? Double.NaN : (p == 0.0 ? 0.0 : (p == 1.0 ? 1.0 : this.findInverseCumulativeProbability(p, 0.0, 0.5, 1.0)));
        return ret;
    }

    public void setAlpha(double a) {
        if (a <= 0.0 || Double.isNaN(a)) {
            throw new IllegalArgumentException("Alpha must be positive.");
        }
        this.alpha = a;
    }

    public void setBeta(double b) {
        if (b <= 0.0 || Double.isNaN(b)) {
            throw new IllegalArgumentException("Beta must be positive.");
        }
        this.beta = b;
    }
}

