/*
 * Decompiled with CFR 0.152.
 */
package net.doodleproject.numerics4j.root;

import net.doodleproject.numerics4j.IterativeMethod;
import net.doodleproject.numerics4j.exception.NumericException;
import net.doodleproject.numerics4j.function.Function;

public class NewtonRootFinder
extends IterativeMethod {
    private Function derivative;
    private Function function;

    public NewtonRootFinder(Function f, Function d) {
        this(f, d, 100, 1.0E-15);
    }

    public NewtonRootFinder(Function f, Function d, int iterations, double error) {
        super(iterations, error);
        this.setFunction(f);
        this.setDerivative(d);
    }

    public double findRoot(double x) throws NumericException {
        IterativeState state = new IterativeState(x);
        this.iterate(state);
        return state.getResult();
    }

    public Function getDerivative() {
        return this.derivative;
    }

    public Function getFunction() {
        return this.function;
    }

    public void setDerivative(Function f) {
        if (f == null) {
            throw new IllegalArgumentException("Derivative can not be null.");
        }
        this.derivative = f;
    }

    public void setFunction(Function f) {
        if (f == null) {
            throw new IllegalArgumentException("Function can not be null.");
        }
        this.function = f;
    }

    private class IterativeState
    implements IterativeMethod.IterativeState {
        private double dx;
        private double fx;
        private int n;
        private double x;

        IterativeState(double t) {
            this.x = t;
        }

        @Override
        public int getIterations() {
            return this.n;
        }

        @Override
        public double getRelativeError() {
            return Math.max(Math.abs(this.fx), Math.abs(this.x / (this.x + this.fx / this.dx) - 1.0));
        }

        @Override
        public void initialize() {
            this.n = 0;
        }

        @Override
        public void iterate() throws NumericException {
            ++this.n;
            this.fx = NewtonRootFinder.this.getFunction().evaluate(this.x);
            this.dx = NewtonRootFinder.this.getDerivative().evaluate(this.x);
            this.x -= this.fx / this.dx;
        }

        double getResult() {
            return this.x;
        }
    }
}

